/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandler;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandlerContext;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

public class ChannelExceptionHandler
implements ChannelHandler {
    static final Logger logger = LoggerFactory.getLogger(ChannelExceptionHandler.class);

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!ctx.channel().isOpen() || "Connection reset by peer".equals(cause.getMessage())) {
            logger.warn("Exception occurred with closed channel.{}", (Object)this.getConnectionIdToAppend(this.getConnectionId()), (Object)cause);
        } else {
            logger.error("Exception in RPC communication. Closing connection.{}", (Object)this.getConnectionIdToAppend(this.getConnectionId()), (Object)cause);
            ctx.close();
        }
    }

    protected String getConnectionId() {
        return null;
    }

    private String getConnectionIdToAppend(String connectionId) {
        if (connectionId != null) {
            return " Connection: " + connectionId;
        }
        return "";
    }
}

