/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.google.common.base.Stopwatch;
import com.dremio.jdbc.shaded.io.netty.channel.EventLoopGroup;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

public class EventLoopCloseable
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EventLoopCloseable.class);
    private final EventLoopGroup eventLoop;

    public EventLoopCloseable(EventLoopGroup eventLoop) {
        this.eventLoop = eventLoop;
    }

    @Override
    public void close() throws Exception {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            this.eventLoop.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.eventLoop.terminationFuture().sync();
            long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsed > 1200L) {
                logger.info("closed eventLoopGroups in " + elapsed + " ms");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failure while shutting down bootstrap context event loops.", e);
            Thread.currentThread().interrupt();
        }
    }
}

