/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.exec.rpc.ConnectionFailedException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RemoteConnection;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcCheckedFuture;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcCommand;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcConnectionHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcFuture;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcOutcomeListener;
import com.dremio.jdbc.shaded.com.google.common.util.concurrent.SettableFuture;
import com.dremio.jdbc.shaded.com.google.protobuf.MessageLite;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

public abstract class FutureBitCommand<T extends MessageLite, C extends RemoteConnection>
implements RpcCommand<T, C> {
    static final Logger logger = LoggerFactory.getLogger(FutureBitCommand.class);
    protected final SettableFuture<T> settableFuture = SettableFuture.create();
    private final RpcCheckedFuture<T> parentFuture = new RpcCheckedFuture<T>(this.settableFuture);

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(C connection) {
        this.doRpcCall(new DeferredRpcOutcome(), connection);
    }

    @Override
    public void connectionSucceeded(C connection) {
        this.connectionAvailable(connection);
    }

    public RpcFuture<T> getFuture() {
        return this.parentFuture;
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t2) {
        this.settableFuture.setException(ConnectionFailedException.mapException(RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t2), type));
    }

    private final class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            FutureBitCommand.this.settableFuture.setException(ex);
        }

        @Override
        public void success(T value, ByteBuf buf) {
            FutureBitCommand.this.parentFuture.setBuffer(buf);
            FutureBitCommand.this.settableFuture.set(value);
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.warn("Interrupted while running the command", e);
            this.failed(new RpcException(e));
        }
    }
}

