/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.exec.rpc.ConnectionFailedException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RemoteConnection;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcCommand;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcConnectionHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcOutcomeListener;
import com.dremio.jdbc.shaded.com.google.protobuf.MessageLite;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

public abstract class ListeningCommand<T extends MessageLite, C extends RemoteConnection>
implements RpcCommand<T, C> {
    static final Logger logger = LoggerFactory.getLogger(ListeningCommand.class);
    private final RpcOutcomeListener<T> listener;

    public ListeningCommand(RpcOutcomeListener<T> listener) {
        this.listener = listener;
    }

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(C connection) {
        this.doRpcCall(new DeferredRpcOutcome(), connection);
    }

    @Override
    public void connectionSucceeded(C connection) {
        this.connectionAvailable(connection);
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t2) {
        this.listener.failed(ConnectionFailedException.mapException(RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t2), type));
    }

    private final class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            ListeningCommand.this.listener.failed(ex);
        }

        @Override
        public void success(T value, ByteBuf buf) {
            ListeningCommand.this.listener.success(value, buf);
        }

        @Override
        public void interrupted(InterruptedException e) {
            ListeningCommand.this.listener.interrupted(e);
        }
    }
}

