/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.exec.proto.GeneralRPCProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcEncoder;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcMessage;
import com.dremio.jdbc.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.com.google.protobuf.Internal;
import com.dremio.jdbc.shaded.com.google.protobuf.MessageLite;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;

public class OutboundRpcMessage
extends RpcMessage {
    static final Logger logger = LoggerFactory.getLogger(OutboundRpcMessage.class);
    final MessageLite pBody;
    final ByteBuf[] dBodies;

    public OutboundRpcMessage(GeneralRPCProtos.RpcMode mode, Internal.EnumLite rpcType, int coordinationId, MessageLite pBody, ByteBuf ... dBodies) {
        this(mode, rpcType.getNumber(), coordinationId, pBody, dBodies);
    }

    OutboundRpcMessage(GeneralRPCProtos.RpcMode mode, int rpcTypeNumber, int coordinationId, MessageLite pBody, ByteBuf ... dBodies) {
        super(mode, rpcTypeNumber, coordinationId);
        this.pBody = pBody;
        ArrayList<ByteBuf> bufs = Lists.newArrayList();
        for (ByteBuf d : dBodies) {
            if (d.readableBytes() == 0) {
                d.release();
                continue;
            }
            bufs.add(d);
        }
        this.dBodies = bufs.toArray(new ByteBuf[bufs.size()]);
    }

    public MessageLite getPBody() {
        return this.pBody;
    }

    public ByteBuf[] getDBodies() {
        return this.dBodies;
    }

    @Override
    public int getBodySize() {
        int len = this.pBody.getSerializedSize();
        len += RpcEncoder.getRawVarintSize(len);
        return len += this.getRawBodySize();
    }

    public int getRawBodySize() {
        int len = 0;
        for (int i = 0; i < this.dBodies.length; ++i) {
            len += this.dBodies[i].readableBytes();
        }
        return len;
    }

    public String toString() {
        return "OutboundRpcMessage [pBody=" + String.valueOf(this.pBody) + ", mode=" + String.valueOf(this.mode) + ", rpcType=" + this.rpcType + ", coordinationId=" + this.coordinationId + ", dBodies=" + Arrays.toString(this.dBodies) + "]";
    }

    @Override
    void release() {
        for (ByteBuf b : this.dBodies) {
            b.release();
        }
    }
}

