/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.common.SerializedExecutor;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.AbstractClient;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RemoteConnection;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcCommand;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcConnectionHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.MeterProviders;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.protobuf.MessageLite;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Counter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Meter;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelFuture;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelFutureListener;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ReconnectingConnection<CONNECTION_TYPE extends RemoteConnection, OUTBOUND_HANDSHAKE extends MessageLite>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ReconnectingConnection.class);
    private static final Meter.MeterProvider<Counter> CONNECTION_BREAK_COUNTER = MeterProviders.newCounterProvider("rpc.failure", "Counts the number of RPC connection breaks");
    private static final long LOST_CONNECTION_REATTEMPT = TimeUnit.MINUTES.toMillis(2L);
    private static final long CONNECTION_SUCCESS_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private static final long TIME_BETWEEN_ATTEMPT = TimeUnit.SECONDS.toMillis(5L);
    private static final int LAZY_ERROR_NOTIFY_RETRIES = Integer.parseInt(System.getProperty("dremio.exec.rpcNotifyRetries", "4"));
    private final AtomicReference<CONNECTION_TYPE> connectionHolder = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<String> clientConnectedHostname = new AtomicReference<Object>(null);
    private final String host;
    private final int port;
    private final OUTBOUND_HANDSHAKE handshake;
    private final String name;
    private final Exec connector;
    private final long lostConnectionReattemptMS;
    private final long connectionSuccessTimeoutMS;
    private final long timeBetweenAttemptMS;
    private volatile ConnectionFailure lastConnectionFailure;

    public ReconnectingConnection(String name, OUTBOUND_HANDSHAKE handshake, String host, int port) {
        this(name, handshake, host, port, LOST_CONNECTION_REATTEMPT, CONNECTION_SUCCESS_TIMEOUT, TIME_BETWEEN_ATTEMPT);
    }

    public ReconnectingConnection(String name, OUTBOUND_HANDSHAKE handshake, String host, int port, long lostConnectionReattemptMS, long connectionSuccessTimeoutMS, long timeBetweenAttemptMS) {
        Preconditions.checkNotNull(host);
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(port > 0);
        this.host = host;
        this.port = port;
        this.name = name;
        this.handshake = handshake;
        this.connector = new Exec();
        this.lostConnectionReattemptMS = lostConnectionReattemptMS;
        this.connectionSuccessTimeoutMS = connectionSuccessTimeoutMS;
        this.timeBetweenAttemptMS = timeBetweenAttemptMS;
    }

    protected abstract String getLocalAddress();

    protected abstract AbstractClient<?, CONNECTION_TYPE, OUTBOUND_HANDSHAKE> getNewClient() throws RpcException;

    public <R extends MessageLite, C extends RpcCommand<R, CONNECTION_TYPE>> void runCommand(C cmd) {
        if (this.closed.get()) {
            cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new IOException("Connection has been closed: " + this.toString()));
        }
        ConnectionRunner r = new ConnectionRunner();
        this.connector.execute(r);
        r.executeCommand(cmd);
    }

    private String getConnectionName(CONNECTION_TYPE connection) {
        if (connection != null) {
            return ((RemoteConnection)connection).getName();
        }
        return "connection is null";
    }

    public CloseHandlerCreator getCloseHandlerCreator() {
        return new CloseHandlerCreator();
    }

    public void addExternalConnection(CONNECTION_TYPE connection) {
        String clientHost = this.clientConnectedHostname.get();
        if (clientHost == null || this.host != null && this.host.compareTo(clientHost) > 0) {
            boolean wasSet = this.connectionHolder.compareAndSet(null, connection);
            if (logger.isDebugEnabled()) {
                if (wasSet) {
                    logger.debug("Adding external connection - {}", (Object)this.getConnectionName(connection));
                } else {
                    logger.debug("Ignoring external connection because connection holder is already set. External connection: - {}", (Object)this.getConnectionName(connection));
                }
            }
        } else {
            logger.debug("Not adding external connection because client has already initiated the connection L {} -> R {}", (Object)clientHost, (Object)this.host);
        }
    }

    @Override
    public void close() {
        RemoteConnection c;
        if (this.closed.getAndSet(true)) {
            logger.info("Attempting to close connection again");
        }
        if ((c = (RemoteConnection)this.connectionHolder.getAndSet(null)) != null) {
            try {
                logger.debug("Closing channel: {}", (Object)this.getConnectionName(c));
                c.getChannel().close().sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void scheduleNotifyHandler(CONNECTION_TYPE conn, int retries) {
        Runnable notifyHandler = () -> {
            boolean notified;
            if (retries > 1) {
                logger.info("Pending completion notification for connection `{}`, possibly due to backpressure. Retry attempt #{}", (Object)conn.getName(), (Object)retries);
            }
            if (!(notified = conn.doLazyNotifyOnClose(retries >= LAZY_ERROR_NOTIFY_RETRIES))) {
                this.scheduleNotifyHandler(conn, retries + 1);
            }
        };
        ((RemoteConnection)conn).getChannel().eventLoop().schedule(notifyHandler, retries == 0 ? 100L : (long)retries * 200L, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return String.format("[%s] %s:%d", this.name, this.host, this.port);
    }

    private class Exec
    extends SerializedExecutor<ConnectionRunner> {
        public Exec() {
            super(ReconnectingConnection.this.name, r -> r.run(), false);
        }

        @Override
        protected void runException(ConnectionRunner command, Throwable t2) {
            command.futureConnection.complete(new ConnectionResult(ReconnectingConnection.this, t2));
        }
    }

    private final class ConnectionRunner
    implements Runnable {
        private final CompletableFuture<ConnectionResult> futureConnection = new CompletableFuture();

        private ConnectionRunner() {
        }

        @Override
        public void run() {
            while (true) {
                RemoteConnection conn;
                if ((conn = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get()) != null && conn.isActive()) {
                    this.futureConnection.complete(new ConnectionResult(ReconnectingConnection.this, false, conn));
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("connection runner: conn status {}", (Object)ReconnectingConnection.this.getConnectionName(conn));
                }
                if (ReconnectingConnection.this.connectionHolder.compareAndSet(conn, null)) break;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Someone has changed the connection, restarting it: {}", (Object)ReconnectingConnection.this.getConnectionName(conn));
            }
            ConnectionFailure failure = ReconnectingConnection.this.lastConnectionFailure;
            if (failure != null && failure.isStillValid()) {
                this.futureConnection.complete(new ConnectionResult(ReconnectingConnection.this, failure));
                return;
            }
            logger.info("[{}]: No connection active, opening new connection {} -> {}:{}.", ReconnectingConnection.this.name, ReconnectingConnection.this.getLocalAddress(), ReconnectingConnection.this.host, ReconnectingConnection.this.port);
            long runUntil = System.currentTimeMillis() + ReconnectingConnection.this.connectionSuccessTimeoutMS;
            ConnectionResult lastResult = null;
            while (System.currentTimeMillis() < runUntil) {
                try {
                    ConnectionResult result = this.attempt(runUntil);
                    if (result.ok()) {
                        this.futureConnection.complete(result);
                        return;
                    }
                    lastResult = result;
                    try {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime + ReconnectingConnection.this.timeBetweenAttemptMS < runUntil) {
                            Thread.sleep(ReconnectingConnection.this.timeBetweenAttemptMS);
                            continue;
                        }
                        Thread.sleep(currentTime < runUntil ? runUntil - currentTime : 0L);
                    }
                    catch (InterruptedException currentTime) {}
                }
                catch (RpcException e) {
                    ConnectionResult failureResult = new ConnectionResult(ReconnectingConnection.this, e);
                    ReconnectingConnection.this.lastConnectionFailure = failureResult.failure;
                    this.futureConnection.complete(failureResult);
                    return;
                }
            }
            if (lastResult == null) {
                lastResult = new ConnectionResult(ReconnectingConnection.this, new TimeoutException("Unable to connect within requested time for " + this.toString()));
            }
            ReconnectingConnection.this.lastConnectionFailure = lastResult.failure;
            this.futureConnection.complete(lastResult);
        }

        private ConnectionResult attempt(long runUntil) throws RpcException {
            ReconnectingConnection.this.clientConnectedHostname.set(ReconnectingConnection.this.getLocalAddress());
            ConnectionHandle future = new ConnectionHandle();
            AbstractClient client = ReconnectingConnection.this.getNewClient();
            client.connectAsClient(future, ReconnectingConnection.this.handshake, ReconnectingConnection.this.host, ReconnectingConnection.this.port);
            logger.debug("Connection attempt - Waiting for connection to be finished: {} -> {}:{}", ReconnectingConnection.this.getLocalAddress(), ReconnectingConnection.this.host, ReconnectingConnection.this.port);
            ConnectionResult result = future.waitForFinished(runUntil);
            logger.debug("Connection attempt - Connection finished: {} -> {}:{}, result {}|{}", ReconnectingConnection.this.getLocalAddress(), ReconnectingConnection.this.host, ReconnectingConnection.this.port, result.ok(), result);
            if (!result.ok()) {
                ReconnectingConnection.this.clientConnectedHostname.set(null);
                return result;
            }
            if (logger.isDebugEnabled()) {
                RemoteConnection conn = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get();
                logger.debug("Connection attempt - connection holder: client to {}:{}, result {}|{}. ConnectionHolder {}", ReconnectingConnection.this.host, ReconnectingConnection.this.port, result.ok(), result, ReconnectingConnection.this.getConnectionName(conn));
            }
            boolean wasSet = ReconnectingConnection.this.connectionHolder.compareAndSet(null, result.connection);
            if (logger.isDebugEnabled()) {
                RemoteConnection conn = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get();
                logger.debug("Connection attempt - connectionHolder wasSet {}: client to {}:{}, result {}|{}. ConnectionHolder {}", wasSet, ReconnectingConnection.this.host, ReconnectingConnection.this.port, result.ok(), result, ReconnectingConnection.this.getConnectionName(conn));
            }
            if (wasSet) {
                ReconnectingConnection.this.clientConnectedHostname.set(null);
                return result;
            }
            result.discard();
            ReconnectingConnection.this.clientConnectedHostname.set(null);
            RemoteConnection outsideSet = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get();
            if (outsideSet == null) {
                return new ConnectionResult(ReconnectingConnection.this, new IllegalStateException("Connection was attempted but then identified as missing " + this.toString()));
            }
            return new ConnectionResult(ReconnectingConnection.this, false, outsideSet);
        }

        public void executeCommand(RpcCommand<? extends MessageLite, CONNECTION_TYPE> cmd) {
            try {
                ConnectionResult result = this.futureConnection.get();
                if (result.ok()) {
                    if (result.hadToConnect()) {
                        cmd.connectionSucceeded((MessageLite)result.connection);
                    } else {
                        cmd.connectionAvailable(result.connection);
                    }
                } else {
                    cmd.connectionFailed(result.failure.type, result.failure.throwable);
                }
            }
            catch (InterruptedException e) {
                cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, e);
            }
            catch (IllegalStateException | ExecutionException e) {
                cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, e.getCause());
            }
        }
    }

    public class CloseHandlerCreator {
        public ChannelFutureListener getHandler(CONNECTION_TYPE connection, ChannelFutureListener parent) {
            return new CloseHandler(ReconnectingConnection.this, connection, parent);
        }
    }

    private class ConnectionFailure {
        private final long validUntil;
        private final RpcConnectionHandler.FailureType type;
        private final Throwable throwable;

        public ConnectionFailure(RpcConnectionHandler.FailureType type, Throwable throwable) {
            this.validUntil = System.currentTimeMillis() + ReconnectingConnection.this.lostConnectionReattemptMS;
            this.type = type;
            this.throwable = throwable;
            CONNECTION_BREAK_COUNTER.withTags("failure_type", type.name()).increment();
        }

        private boolean isStillValid() {
            return System.currentTimeMillis() < this.validUntil;
        }
    }

    private static class ConnectionResult {
        private final boolean hadToConnect;
        private final CONNECTION_TYPE connection;
        private final ConnectionFailure failure;
        final /* synthetic */ ReconnectingConnection this$0;

        public ConnectionResult(boolean hadToConnect, CONNECTION_TYPE connection) {
            this.this$0 = var1_1;
            this.hadToConnect = hadToConnect;
            this.connection = connection;
            this.failure = null;
        }

        public ConnectionResult(ReconnectingConnection reconnectingConnection, ConnectionFailure failure) {
            this.this$0 = reconnectingConnection;
            this.hadToConnect = false;
            this.connection = null;
            this.failure = failure;
        }

        public ConnectionResult(ReconnectingConnection reconnectingConnection, Throwable t2) {
            this(reconnectingConnection, reconnectingConnection.new ConnectionFailure(RpcConnectionHandler.FailureType.CONNECTION, t2));
        }

        public boolean ok() {
            return this.failure == null;
        }

        public boolean hadToConnect() {
            return this.hadToConnect;
        }

        public void discard() {
            if (this.connection != null) {
                logger.debug("Discarding connection. Closing channel {}", (Object)this.this$0.getConnectionName(this.connection));
                try {
                    ((RemoteConnection)this.connection).getChannel().close().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private final class ConnectionHandle
    implements RpcConnectionHandler<CONNECTION_TYPE> {
        private CompletableFuture<ConnectionResult> conn = new CompletableFuture();
        private boolean tookTooLong;

        private ConnectionHandle() {
        }

        @Override
        public synchronized void connectionSucceeded(CONNECTION_TYPE connection) {
            if (!this.tookTooLong) {
                this.conn.complete(new ConnectionResult(ReconnectingConnection.this, true, connection));
                return;
            }
            try {
                logger.debug("Closing channel because took too long: {}", (Object)ReconnectingConnection.this.getConnectionName(connection));
                ((RemoteConnection)connection).getChannel().close().sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t2) {
            if (!this.tookTooLong) {
                this.conn.complete(new ConnectionResult(ReconnectingConnection.this, new ConnectionFailure(type, t2)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionResult waitForFinished(long untilTime) {
            try {
                ConnectionResult connectionResult = this.conn.get(Math.max(1L, untilTime - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
                return connectionResult;
            }
            catch (InterruptedException | TimeoutException e) {
                ConnectionResult connectionResult = new ConnectionResult(ReconnectingConnection.this, new ConnectionFailure(RpcConnectionHandler.FailureType.CONNECTION, e));
                return connectionResult;
            }
            catch (ExecutionException e) {
                ConnectionResult connectionResult = new ConnectionResult(ReconnectingConnection.this, new ConnectionFailure(RpcConnectionHandler.FailureType.CONNECTION, e.getCause()));
                return connectionResult;
            }
            finally {
                this.tookTooLong = true;
            }
        }
    }

    protected static class CloseHandler
    implements ChannelFutureListener {
        private CONNECTION_TYPE connection;
        private ChannelFutureListener parent;
        final /* synthetic */ ReconnectingConnection this$0;

        public CloseHandler(CONNECTION_TYPE connection, ChannelFutureListener parent) {
            this.this$0 = this$0;
            this.connection = connection;
            this.parent = parent;
            ((RemoteConnection)this.connection).setupLazyNotifyOnClose();
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean wasSet = this.this$0.connectionHolder.compareAndSet(this.connection, null);
            this.parent.operationComplete(future);
            this.this$0.scheduleNotifyHandler(this.connection, 0);
            if (!wasSet) {
                logger.info("Old connection is already replaced with new connection");
            }
        }
    }
}

