/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.ErrorHelper;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.OutOfMemoryOrResourceExceptionContext;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.memory.MemoryDebugInfo;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.GeneralRPCProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.OutboundRpcMessage;
import com.dremio.jdbc.shaded.com.google.protobuf.CodedOutputStream;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBufAllocator;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBufOutputStream;
import com.dremio.jdbc.shaded.io.netty.buffer.CompositeByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandlerContext;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelPromise;
import com.dremio.jdbc.shaded.io.netty.handler.codec.PromisingMessageToMessageEncoder;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.patch.ArrowByteBufAllocator;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.List;

class RpcEncoder
extends PromisingMessageToMessageEncoder<OutboundRpcMessage> {
    final Logger logger;
    static final int HEADER_TAG = RpcEncoder.makeTag(1, 2);
    static final int PROTOBUF_BODY_TAG = RpcEncoder.makeTag(2, 2);
    static final int RAW_BODY_TAG = RpcEncoder.makeTag(3, 2);
    static final int HEADER_TAG_LENGTH = RpcEncoder.getRawVarintSize(HEADER_TAG);
    static final int PROTOBUF_BODY_TAG_LENGTH = RpcEncoder.getRawVarintSize(PROTOBUF_BODY_TAG);
    static final int RAW_BODY_TAG_LENGTH = RpcEncoder.getRawVarintSize(RAW_BODY_TAG);

    public RpcEncoder(String name) {
        super(OutboundRpcMessage.class);
        this.logger = LoggerFactory.getLogger(RpcEncoder.class.getCanonicalName() + "-" + name);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, OutboundRpcMessage msg, List<Object> out, ChannelPromise promise) throws Exception {
        ByteBuf withoutRawMessage;
        if (!ctx.channel().isOpen()) {
            this.logger.debug("Channel closed, skipping encode.");
            msg.release();
            return;
        }
        GeneralRPCProtos.RpcHeader header = GeneralRPCProtos.RpcHeader.newBuilder().setMode(msg.mode).setCoordinationId(msg.coordinationId).setRpcType(msg.rpcType).build();
        int headerLength = header.getSerializedSize();
        int protoBodyLength = msg.pBody.getSerializedSize();
        int rawBodyLength = msg.getRawBodySize();
        int withoutRawLength = HEADER_TAG_LENGTH + RpcEncoder.getRawVarintSize(headerLength) + headerLength + PROTOBUF_BODY_TAG_LENGTH + RpcEncoder.getRawVarintSize(protoBodyLength) + protoBodyLength;
        int fullLength = rawBodyLength > 0 ? withoutRawLength + (RAW_BODY_TAG_LENGTH + RpcEncoder.getRawVarintSize(rawBodyLength) + rawBodyLength) : withoutRawLength;
        if (rawBodyLength > 0) {
            try {
                withoutRawMessage = ctx.alloc().buffer(fullLength + 5);
            }
            catch (OutOfMemoryException | OutOfMemoryError ex) {
                msg.release();
                Object oomDetails = "Out of memory while encoding data. ";
                UserException.Builder uexBuilder = UserException.memoryError(ex);
                if (ErrorHelper.isDirectMemoryException(ex)) {
                    ByteBufAllocator byteBufAllocator = ctx.alloc();
                    if (byteBufAllocator instanceof ArrowByteBufAllocator) {
                        BufferAllocator bufferAllocator = ((ArrowByteBufAllocator)byteBufAllocator).unwrap();
                        oomDetails = (String)oomDetails + (ex instanceof OutOfMemoryException ? MemoryDebugInfo.getDetailsOnAllocationFailure((OutOfMemoryException)ex, bufferAllocator) : MemoryDebugInfo.getSummaryFromRoot(bufferAllocator));
                    }
                    uexBuilder.setAdditionalExceptionContext(new OutOfMemoryOrResourceExceptionContext(OutOfMemoryOrResourceExceptionContext.MemoryType.DIRECT_MEMORY, (String)oomDetails));
                } else {
                    uexBuilder.setAdditionalExceptionContext(new OutOfMemoryOrResourceExceptionContext(OutOfMemoryOrResourceExceptionContext.MemoryType.HEAP_MEMORY, (String)oomDetails));
                }
                promise.setFailure(uexBuilder.buildSilently());
                return;
            }
        } else {
            withoutRawMessage = UnpooledByteBufAllocator.DEFAULT.heapBuffer(fullLength + 5);
        }
        ByteBufOutputStream os = new ByteBufOutputStream(withoutRawMessage);
        CodedOutputStream cos = CodedOutputStream.newInstance(os);
        cos.writeRawVarint32(fullLength);
        cos.writeRawVarint32(HEADER_TAG);
        cos.writeRawVarint32(headerLength);
        header.writeTo(cos);
        cos.writeRawVarint32(PROTOBUF_BODY_TAG);
        cos.writeRawVarint32(protoBodyLength);
        msg.pBody.writeTo(cos);
        if (msg.getRawBodySize() > 0) {
            cos.writeRawVarint32(RAW_BODY_TAG);
            cos.writeRawVarint32(rawBodyLength);
            cos.flush();
            CompositeByteBuf cbb = new CompositeByteBuf(withoutRawMessage.alloc(), true, msg.dBodies.length + 1);
            cbb.addComponent(withoutRawMessage);
            int bufLength = withoutRawMessage.readableBytes();
            for (ByteBuf b : msg.dBodies) {
                cbb.addComponent(b);
                bufLength += b.readableBytes();
            }
            cbb.writerIndex(bufLength);
            out.add(cbb);
        } else {
            cos.flush();
            out.add(withoutRawMessage);
        }
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static int getRawVarintSize(int value) {
        int count = 0;
        while ((value & 0xFFFFFF80) != 0) {
            ++count;
            value >>>= 7;
        }
        return ++count;
    }
}

