/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.NamedThreadFactory;
import com.dremio.jdbc.shaded.io.netty.channel.EventLoopGroup;
import com.dremio.jdbc.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import com.dremio.jdbc.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import com.dremio.jdbc.shaded.io.netty.channel.epoll.EpollSocketChannel;
import com.dremio.jdbc.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.dremio.jdbc.shaded.io.netty.channel.socket.ServerSocketChannel;
import com.dremio.jdbc.shaded.io.netty.channel.socket.SocketChannel;
import com.dremio.jdbc.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.dremio.jdbc.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import com.dremio.jdbc.shaded.io.netty.util.internal.SystemPropertyUtil;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;

public final class TransportCheck {
    static final Logger logger = LoggerFactory.getLogger(TransportCheck.class);
    private static final String USE_LINUX_EPOLL = "dremio.exec.enable-epoll";
    public static final boolean SUPPORTS_EPOLL;
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER;

    private TransportCheck() {
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends SocketChannel> getClientSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, String prefix) {
        if (SUPPORTS_EPOLL) {
            return new EpollEventLoopGroup(nThreads, TransportCheck.newThreadFactory(prefix));
        }
        return new NioEventLoopGroup(nThreads, TransportCheck.newThreadFactory(prefix));
    }

    public static ThreadFactory newThreadFactory(String prefix) {
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory(prefix);
        return runnable -> {
            Thread result = namedThreadFactory.newThread(runnable);
            result.setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
            return result;
        };
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.US).trim();
        SUPPORTS_EPOLL = name.startsWith("linux") && SystemPropertyUtil.getBoolean(USE_LINUX_EPOLL, false);
        UNCAUGHT_EXCEPTION_HANDLER = (thread, t2) -> logger.error("Uncaught exception in thread {}", (Object)thread.getName(), (Object)t2);
    }
}

