/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc.proxy;

import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBufUtil;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandler;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandlerContext;
import com.dremio.jdbc.shaded.io.netty.handler.codec.EncoderException;
import com.dremio.jdbc.shaded.io.netty.handler.codec.MessageToByteEncoder;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressEncoder;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5Message;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

@ChannelHandler.Sharable
public class DremioSocks5ClientEncoder
extends MessageToByteEncoder<Socks5Message> {
    public static final DremioSocks5ClientEncoder DEFAULT = new DremioSocks5ClientEncoder();
    private final Socks5AddressEncoder addressEncoder;

    protected DremioSocks5ClientEncoder() {
        this(Socks5AddressEncoder.DEFAULT);
    }

    public DremioSocks5ClientEncoder(Socks5AddressEncoder addressEncoder) {
        this.addressEncoder = Objects.requireNonNull(addressEncoder, "addressEncoder");
    }

    protected final Socks5AddressEncoder addressEncoder() {
        return this.addressEncoder;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Socks5Message msg, ByteBuf out) throws Exception {
        if (msg instanceof Socks5InitialRequest) {
            DremioSocks5ClientEncoder.encodeAuthMethodRequest((Socks5InitialRequest)msg, out);
        } else if (msg instanceof Socks5PasswordAuthRequest) {
            DremioSocks5ClientEncoder.encodePasswordAuthRequest((Socks5PasswordAuthRequest)msg, out);
        } else if (msg instanceof Socks5CommandRequest) {
            this.encodeCommandRequest((Socks5CommandRequest)msg, out);
        } else {
            throw new EncoderException("unsupported message type: " + String.valueOf(msg == null ? "null" : msg.getClass()));
        }
    }

    private static void encodeAuthMethodRequest(Socks5InitialRequest msg, ByteBuf out) {
        out.writeByte(msg.version().byteValue());
        List<Socks5AuthMethod> authMethods = msg.authMethods();
        int numAuthMethods = authMethods.size();
        out.writeByte(numAuthMethods);
        if (authMethods instanceof RandomAccess) {
            for (int i = 0; i < numAuthMethods; ++i) {
                out.writeByte(authMethods.get(i).byteValue());
            }
        } else {
            for (Socks5AuthMethod a : authMethods) {
                out.writeByte(a.byteValue());
            }
        }
    }

    private static void encodePasswordAuthRequest(Socks5PasswordAuthRequest msg, ByteBuf out) {
        out.writeByte(1);
        String username = msg.username();
        out.writeByte(username.length());
        ByteBufUtil.writeAscii(out, (CharSequence)username);
        String password = msg.password();
        out.writeByte(password.length());
        ByteBufUtil.writeAscii(out, (CharSequence)password);
    }

    private void encodeCommandRequest(Socks5CommandRequest msg, ByteBuf out) throws Exception {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.type().byteValue());
        out.writeByte(0);
        Socks5AddressType dstAddrType = msg.dstAddrType();
        out.writeByte(dstAddrType.byteValue());
        this.addressEncoder.encodeAddress(dstAddrType, msg.dstAddr(), out);
        ByteBufUtil.writeShortBE(out, msg.dstPort());
    }
}

