/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc.proxy;

import com.dremio.jdbc.shaded.com.dremio.exec.rpc.proxy.DremioSocks5ProxyHandler;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;

public final class ProxyConfig {
    public static final String SOCKS_PROXY_HOST = "socksProxyHost";
    public static String SOCKS_PROXY_PORT = "socksProxyPort";
    public static String SOCKS_PROXY_USERNAME = "socksProxyUsername";
    public static String SOCKS_PROXY_PASSWORD = "socksProxyPassword";
    private static final String DEFAULT_PORT = "1080";
    private final String socksProxyHost;
    private final String socksProxyPort;
    private final Optional<String> socksProxyUsername;
    private final Optional<String> socksProxyPassword;
    private final InetSocketAddress proxyAddress;

    private ProxyConfig(Properties props) {
        this.socksProxyHost = this.getProxyProperty(SOCKS_PROXY_HOST, props);
        this.socksProxyPort = Optional.ofNullable(this.getProxyProperty(SOCKS_PROXY_PORT, props)).orElse(DEFAULT_PORT);
        this.socksProxyUsername = this.getOptionalProperty(SOCKS_PROXY_USERNAME, props);
        this.socksProxyPassword = this.getOptionalProperty(SOCKS_PROXY_PASSWORD, props);
        this.proxyAddress = new InetSocketAddress(this.socksProxyHost, Integer.parseInt(this.socksProxyPort));
    }

    private String getProxyProperty(String key, Properties props) {
        return props.getProperty(key);
    }

    private Optional<String> getOptionalProperty(String key, Properties props) {
        return Optional.ofNullable(props.getProperty(key));
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public DremioSocks5ProxyHandler createProxyHandler() {
        try {
            return this.socksProxyUsername.map(user -> new DremioSocks5ProxyHandler(this.proxyAddress, (String)user, this.socksProxyPassword.get())).orElse(new DremioSocks5ProxyHandler(this.proxyAddress));
        }
        catch (NoSuchElementException nse) {
            throw new NoSuchElementException("Please provide both socksProxyUsername and socksProxyPassword if your proxy requires authentication");
        }
    }

    public static Optional<ProxyConfig> of(Properties props) {
        String strPort = Optional.ofNullable(props.getProperty(SOCKS_PROXY_PORT)).orElse(DEFAULT_PORT);
        int port = ProxyConfig.validatePort(strPort);
        props.setProperty(SOCKS_PROXY_PORT, String.valueOf(port));
        return Optional.of(props).filter(ProxyConfig::hasRequiredProperties).map(ProxyConfig::new);
    }

    private static Integer validatePort(String strPort) {
        int port;
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Please provide a parseable integer value for socksProxyPort");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Please set socksProxyPort to a valid port number when socksProxyHost is set.");
        }
        return port;
    }

    private static boolean hasRequiredProperties(Properties props) {
        return props.containsKey(SOCKS_PROXY_HOST);
    }
}

