/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc.ssl;

import com.dremio.jdbc.shaded.com.dremio.config.DremioConfig;
import com.dremio.jdbc.shaded.com.dremio.security.SecurityFolder;
import com.dremio.jdbc.shaded.com.dremio.services.credentials.CredentialsException;
import com.dremio.jdbc.shaded.com.dremio.services.credentials.CredentialsService;
import com.dremio.jdbc.shaded.com.dremio.ssl.SSLConfig;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.base.Strings;
import com.dremio.jdbc.shaded.com.google.common.io.BaseEncoding;
import com.dremio.jdbc.shaded.com.google.common.net.InetAddresses;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.RandomStringUtils;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.ASN1Encodable;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.DERSequence;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x500.X500NameBuilder;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x500.style.BCStyle;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x509.Extension;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x509.GeneralName;
import com.dremio.jdbc.shaded.org.bouncycastle.cert.X509v3CertificateBuilder;
import com.dremio.jdbc.shaded.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.dremio.jdbc.shaded.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.dremio.jdbc.shaded.org.bouncycastle.operator.ContentSigner;
import com.dremio.jdbc.shaded.org.bouncycastle.operator.OperatorCreationException;
import com.dremio.jdbc.shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.dremio.jdbc.shaded.org.joda.time.DateTime;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Provider;

public class SSLConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(SSLConfigurator.class);
    @VisibleForTesting
    public static final String UNSECURE_PASSWORD = "averylongandunsecurepasswordfordremiokeystore";
    private static final char[] UNSECURE_PASSWORD_CHAR_ARRAY = "averylongandunsecurepasswordfordremiokeystore".toCharArray();
    public static final String KEY_STORE_FILE = "keystore";
    public static final String TRUST_STORE_FILE = "certs";
    public static final Set<PosixFilePermission> TRUST_STORE_FILE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ);
    private final DremioConfig config;
    private final Provider<CredentialsService> credentialsServiceProvider;
    private final String prefix;
    private final String communicationPath;

    public SSLConfigurator(DremioConfig config, Provider<CredentialsService> credentialsServiceProvider, String prefix, String communicationPath) {
        this.config = config;
        this.credentialsServiceProvider = credentialsServiceProvider;
        this.prefix = prefix;
        this.communicationPath = communicationPath;
    }

    public Optional<SSLConfig> getSSLConfig(boolean disablePeerVerification, String hostName, String ... alternativeHostNames) throws GeneralSecurityException, IOException {
        boolean enabled = this.getBooleanConfig("enabled");
        if (!enabled) {
            return Optional.empty();
        }
        SSLConfig.Builder builder = SSLConfig.newBuilderForServer();
        builder.setDisablePeerVerification(disablePeerVerification);
        boolean autoGenerated = this.getBooleanConfig("auto-certificate.enabled");
        if (autoGenerated) {
            logger.warn("*** Using generated self-signed SSL settings for server ('{}' component) ***\nUsing auto-generated certificates is not secure. Please consider switching to your own certificates.", (Object)this.communicationPath);
            SecurityFolder securityFolder = SecurityFolder.of(this.config);
            String localWritePathString = this.config.getString("paths.local");
            boolean configured = this.configureUsingPreviouslyGeneratedStores(builder, securityFolder, localWritePathString);
            if (!configured) {
                logger.info("No previous keystore detected, creating certificate. This operation might take time...");
                this.generateCertificatesAndConfigure(builder, securityFolder, localWritePathString, hostName, alternativeHostNames);
            }
            builder.setDisablePeerVerification(true);
            return Optional.of(builder.build());
        }
        this.configureUsingConfFile(builder);
        return Optional.of(builder.build());
    }

    private Optional<String> getStringConfig(String base) {
        assert (this.config.hasPath(this.prefix + base));
        String value = this.config.getString(this.prefix + base);
        return Strings.isNullOrEmpty(value) ? Optional.empty() : Optional.of(value);
    }

    private boolean getBooleanConfig(String base) {
        assert (this.config.hasPath(this.prefix + base));
        return this.config.getBoolean(this.prefix + base);
    }

    private boolean configureUsingPreviouslyGeneratedStores(SSLConfig.Builder builder, SecurityFolder securityFolder, String localWritePathString) throws GeneralSecurityException, IOException {
        if (securityFolder.exists(KEY_STORE_FILE)) {
            logger.debug("Using previously generated keystore/truststore");
            this.moveTrustStoreIfNecessary(securityFolder, localWritePathString);
            Path trustStorePath = Paths.get(localWritePathString, TRUST_STORE_FILE);
            Preconditions.checkState(Files.exists(trustStorePath, new LinkOption[0]), "auto-generated trust store is missing");
            builder.setKeyStorePath(securityFolder.resolve(KEY_STORE_FILE).toString()).setKeyStorePassword(UNSECURE_PASSWORD).setTrustStorePath(trustStorePath.toString()).setTrustStorePassword(UNSECURE_PASSWORD);
            return true;
        }
        return false;
    }

    private void moveTrustStoreIfNecessary(SecurityFolder securityFolder, String localWritePathString) {
        Path toPath = Paths.get(localWritePathString, TRUST_STORE_FILE);
        if (Files.exists(toPath, new LinkOption[0])) {
            return;
        }
        Path fromPath = securityFolder.resolve(TRUST_STORE_FILE);
        Preconditions.checkState(Files.exists(fromPath, new LinkOption[0]));
        logger.info("Moving trust store from '{}' to '{}'", (Object)fromPath, (Object)toPath);
        try {
            Files.move(fromPath, toPath, new CopyOption[0]);
        }
        catch (IOException e) {
            String message = String.format("Failed to move trust store from '%s' to '%s'. Please do so manually. Also, set permissions to 644 on trust store.", fromPath, toPath);
            logger.error(message, e);
            throw new RuntimeException(message, e);
        }
        try {
            Files.setPosixFilePermissions(toPath, TRUST_STORE_FILE_PERMISSIONS);
        }
        catch (IOException e) {
            String message = String.format("Failed to set 644 permissions on trust store at '%s'. Please do so manually.", toPath);
            logger.error(message, e);
            throw new RuntimeException(message, e);
        }
    }

    private void generateCertificatesAndConfigure(SSLConfig.Builder builder, SecurityFolder securityFolder, String localWritePathString, String hostName, String ... alternativeHostNames) throws GeneralSecurityException, IOException {
        ContentSigner contentSigner;
        String storeType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(storeType);
        keyStore.load(null, null);
        KeyStore trustStore = KeyStore.getInstance(storeType);
        trustStore.load(null, null);
        SecureRandom random = new SecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        DateTime now = DateTime.now();
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, hostName).addRDN(BCStyle.OU, "Dremio Corp. (auto-generated)").addRDN(BCStyle.O, "Dremio Corp. (auto-generated)").addRDN(BCStyle.L, "Mountain View").addRDN(BCStyle.ST, "California").addRDN(BCStyle.C, "US");
        Date notBefore = now.minusDays(1).toDate();
        Date notAfter = now.plusYears(1).toDate();
        BigInteger serialNumber = new BigInteger(128, random);
        ASN1Encodable[] alternativeSubjectNames = new GeneralName[alternativeHostNames.length + 1];
        alternativeSubjectNames[0] = SSLConfigurator.newGeneralName(hostName);
        for (int i = 0; i < alternativeHostNames.length; ++i) {
            alternativeSubjectNames[i + 1] = SSLConfigurator.newGeneralName(alternativeHostNames[i]);
        }
        X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic()).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence(alternativeSubjectNames));
        try {
            contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException(e);
        }
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
        certificate.checkValidity(now.toDate());
        certificate.verify(certificate.getPublicKey());
        String fingerprint = BaseEncoding.base16().withSeparator(":", 2).encode(MessageDigest.getInstance("SHA-256").digest(certificate.getEncoded()));
        logger.info("Certificate created (SHA-256 fingerprint: {})", (Object)fingerprint);
        keyStore.setKeyEntry("DremioAutoGeneratedPrivateKey", keyPair.getPrivate(), UNSECURE_PASSWORD_CHAR_ARRAY, new Certificate[]{certificate});
        trustStore.setEntry("DremioAutoGeneratedCert" + RandomStringUtils.randomNumeric(5), new KeyStore.TrustedCertificateEntry(certificate), null);
        try (OutputStream stream = securityFolder.newSecureOutputStream(KEY_STORE_FILE, SecurityFolder.OpenOption.CREATE_ONLY);){
            keyStore.store(stream, UNSECURE_PASSWORD_CHAR_ARRAY);
        }
        Path trustStorePath = Paths.get(localWritePathString, TRUST_STORE_FILE);
        try (OutputStream stream = Files.newOutputStream(trustStorePath, StandardOpenOption.CREATE_NEW);){
            trustStore.store(stream, UNSECURE_PASSWORD_CHAR_ARRAY);
        }
        Files.setPosixFilePermissions(trustStorePath, TRUST_STORE_FILE_PERMISSIONS);
        builder.setKeyStoreType(storeType).setKeyStorePath(securityFolder.resolve(KEY_STORE_FILE).toString()).setKeyStorePassword(UNSECURE_PASSWORD).setTrustStoreType(storeType).setTrustStorePath(trustStorePath.toString()).setTrustStorePassword(UNSECURE_PASSWORD);
    }

    private static GeneralName newGeneralName(String name) {
        int nameType = InetAddresses.isInetAddress(name) ? 7 : 2;
        return new GeneralName(nameType, name);
    }

    private String lookupPassword(String passwordPattern, Provider<CredentialsService> credentialsServiceProvider) {
        try {
            return ((CredentialsService)credentialsServiceProvider.get()).lookup(passwordPattern);
        }
        catch (IllegalArgumentException e) {
            logger.warn("The string used to locate secret is not a valid URI.");
            return passwordPattern;
        }
        catch (CredentialsException e) {
            throw new RuntimeException(e);
        }
    }

    private void configureUsingConfFile(SSLConfig.Builder builder) {
        Optional<String> keyStorePath = this.getStringConfig("keyStore");
        if (!keyStorePath.isPresent()) {
            throw new IllegalArgumentException(String.format("No keystore configured, and certificate auto-generation is disabled. But SSL is enabled for '%s' path", this.communicationPath));
        }
        logger.info("Using configured keystore for '{}' component at '{}'", (Object)this.communicationPath, (Object)keyStorePath);
        keyStorePath.ifPresent(builder::setKeyStorePath);
        this.getStringConfig("keyStorePassword").ifPresent(jksPwdUri -> builder.setKeyStorePassword(this.lookupPassword((String)jksPwdUri, this.credentialsServiceProvider)));
        this.getStringConfig("keyPassword").ifPresent(keyPwdUri -> builder.setKeyPassword(this.lookupPassword((String)keyPwdUri, this.credentialsServiceProvider)));
        this.getStringConfig("keyStoreType").ifPresent(builder::setKeyStoreType);
        this.getStringConfig("trustStoreType").ifPresent(builder::setTrustStoreType);
        this.getStringConfig("trustStore").ifPresent(builder::setTrustStorePath);
        this.getStringConfig("trustStorePassword").ifPresent(tsPwdUri -> builder.setTrustStorePassword(this.lookupPassword((String)tsPwdUri, this.credentialsServiceProvider)));
    }

    public Optional<KeyStore> getTrustStore() throws GeneralSecurityException, IOException {
        char[] trustStorePassword;
        String trustStorePath;
        Optional<String> configuredPath = this.getStringConfig("trustStore");
        if (configuredPath.isPresent()) {
            logger.info("Loading configured trust store at {}", (Object)configuredPath.get());
            trustStorePath = configuredPath.get();
            trustStorePassword = this.getStringConfig("trustStorePassword").map(pwdUri -> this.lookupPassword((String)pwdUri, this.credentialsServiceProvider).toCharArray()).orElse(new char[0]);
        } else {
            Path path = Paths.get(this.config.getString("paths.local"), TRUST_STORE_FILE);
            if (Files.notExists(path, new LinkOption[0])) {
                return Optional.empty();
            }
            trustStorePath = path.toString();
            trustStorePassword = UNSECURE_PASSWORD_CHAR_ARRAY;
        }
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream stream = Files.newInputStream(Paths.get(trustStorePath, new String[0]), new OpenOption[0]);){
            trustStore.load(stream, trustStorePassword);
        }
        return Optional.of(trustStore);
    }
}

