/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector;

import com.dremio.jdbc.shaded.com.dremio.common.util.ObjectType;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BufferBacked;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compare.VectorVisitor;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.ObjectHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.CallBack;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectVector
extends BaseValueVector
implements FieldVector {
    private final String name;
    private int maxCount = 0;
    private int count = 0;
    private int allocationSize = 4096;
    private List<Object[]> objectArrayList = new ArrayList<Object[]>();

    public ObjectVector(String name, BufferAllocator allocator) {
        super(allocator);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addNewArray() {
        this.objectArrayList.add(new Object[this.allocationSize]);
        this.maxCount += this.allocationSize;
    }

    @Override
    public Field getField() {
        return new Field(this.name, new FieldType(false, ObjectType.INTERNAL_OBJECT_TYPE, null), null);
    }

    @Override
    protected FieldReader getReaderImpl() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    public void set(int index, Object obj) {
        int listOffset = index / this.allocationSize;
        if (listOffset >= this.objectArrayList.size()) {
            this.addNewArray();
        }
        this.objectArrayList.get((int)listOffset)[index % this.allocationSize] = obj;
    }

    public boolean setSafe(int index, long value) {
        this.set(index, value);
        return true;
    }

    protected void set(int index, ObjectHolder holder) {
        this.set(index, holder.obj);
    }

    @Override
    public void setNull(int index) {
        this.set(index, null);
    }

    public boolean setSafe(int index, ObjectHolder holder) {
        this.set(index, holder);
        return true;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.count = valueCount;
    }

    @Override
    public void reset() {
        this.count = 0;
        this.maxCount = 0;
        this.objectArrayList = new ArrayList<Object[]>();
        this.addNewArray();
    }

    public void generateTestData(int values) {
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.addNewArray();
    }

    public void allocateNew(int valueCount) throws OutOfMemoryException {
        while (this.maxCount < valueCount) {
            this.addNewArray();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.allocateNew();
        return true;
    }

    @Override
    public int getBufferSize() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.objectArrayList.clear();
        this.maxCount = 0;
        this.count = 0;
    }

    @Override
    public long getValidityBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Types.MinorType getMinorType() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator bufferAllocator) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair getTransferPair(String s2, BufferAllocator bufferAllocator, CallBack callBack) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator bufferAllocator, CallBack callBack) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public int getValueCapacity() {
        return this.maxCount;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public Iterator<ValueVector> iterator() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public Object getObject(int index) {
        int listOffset = index / this.allocationSize;
        if (listOffset >= this.objectArrayList.size()) {
            this.addNewArray();
        }
        return this.objectArrayList.get(listOffset)[index % this.allocationSize];
    }

    @Override
    public int getNullCount() {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public int getValueCount() {
        return this.count;
    }

    public Object get(int index) {
        return this.getObject(index);
    }

    public void get(int index, ObjectHolder holder) {
        holder.obj = this.getObject(index);
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void reAlloc() {
        this.addNewArray();
    }

    @Override
    public int hashCode(int index) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public int hashCode(int i, ArrowBufHasher arrowBufHasher) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> vectorVisitor, IN in) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }
}

