/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.AbstractSqlAccessor;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DateMilliVector;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.TimeZone;

public class DateMilliAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.DATE);
    private final TimeZone defaultTimeZone;
    private final DateMilliVector ac;

    public DateMilliAccessor(DateMilliVector vector, TimeZone defaultTZ) {
        this.ac = vector;
        this.defaultTimeZone = Preconditions.checkNotNull(defaultTZ, "Null TimeZone supplied.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index, this.defaultTimeZone);
    }

    @Override
    public Date getDate(int index, Calendar calendar) {
        Preconditions.checkNotNull(calendar, "Invalid calendar used when attempting to retrieve date.");
        return this.getDate(index, calendar.getTimeZone());
    }

    private Date getDate(int index, TimeZone tz) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDateTime ldt = this.ac.getObject(index);
        if (tz != this.defaultTimeZone) {
            long arrowMillis = this.ac.get(index);
            ldt = ldt.minus(tz.getOffset(arrowMillis) - this.defaultTimeZone.getOffset(arrowMillis), ChronoUnit.MILLIS);
        }
        return new Date(Timestamp.valueOf(ldt).getTime());
    }
}

