/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor;

import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.BigIntAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.BitAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.DateMilliAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.DecimalAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.FixedSizeBinaryAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.Float4Accessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.Float8Accessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.GenericAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.IntAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.IntervalDayAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.IntervalYearAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.SmallIntAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.SqlAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.TimeMilliAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.TimeStampMilliAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.TinyIntAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.UInt1Accessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.UInt2Accessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.UInt4Accessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.UInt8Accessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.UnionSqlAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.VarBinaryAccessor;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.VarCharAccessor;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BigIntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BitVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DateMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DecimalVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FixedSizeBinaryVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.Float4Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.Float8Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntervalDayVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntervalYearVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.SmallIntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeStampMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TinyIntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt1Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt2Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt4Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt8Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VarBinaryVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VarCharVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.UnionVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import java.util.TimeZone;

public final class SqlAccessorBuilder {
    private SqlAccessorBuilder() {
    }

    public static SqlAccessor getSqlAccessor(ValueVector vector, TimeZone defaultTz) {
        Types.MinorType type = Types.getMinorTypeForArrowType(vector.getField().getType());
        switch (type) {
            case UNION: {
                return new UnionSqlAccessor((UnionVector)vector);
            }
            case TINYINT: {
                return new TinyIntAccessor((TinyIntVector)vector);
            }
            case UINT1: {
                return new UInt1Accessor((UInt1Vector)vector);
            }
            case UINT2: {
                return new UInt2Accessor((UInt2Vector)vector);
            }
            case SMALLINT: {
                return new SmallIntAccessor((SmallIntVector)vector);
            }
            case INT: {
                return new IntAccessor((IntVector)vector);
            }
            case UINT4: {
                return new UInt4Accessor((UInt4Vector)vector);
            }
            case FLOAT4: {
                return new Float4Accessor((Float4Vector)vector);
            }
            case INTERVALYEAR: {
                return new IntervalYearAccessor((IntervalYearVector)vector);
            }
            case TIMEMILLI: {
                return new TimeMilliAccessor((TimeMilliVector)vector, defaultTz);
            }
            case BIGINT: {
                return new BigIntAccessor((BigIntVector)vector);
            }
            case UINT8: {
                return new UInt8Accessor((UInt8Vector)vector);
            }
            case FLOAT8: {
                return new Float8Accessor((Float8Vector)vector);
            }
            case DATEMILLI: {
                return new DateMilliAccessor((DateMilliVector)vector, defaultTz);
            }
            case TIMESTAMPMILLI: {
                return new TimeStampMilliAccessor((TimeStampMilliVector)vector, defaultTz);
            }
            case INTERVALDAY: {
                return new IntervalDayAccessor((IntervalDayVector)vector);
            }
            case DECIMAL: {
                return new DecimalAccessor((DecimalVector)vector);
            }
            case FIXEDSIZEBINARY: {
                return new FixedSizeBinaryAccessor((FixedSizeBinaryVector)vector);
            }
            case VARBINARY: {
                return new VarBinaryAccessor((VarBinaryVector)vector);
            }
            case VARCHAR: {
                return new VarCharAccessor((VarCharVector)vector);
            }
            case BIT: {
                return new BitAccessor((BitVector)vector);
            }
            case STRUCT: 
            case LIST: 
            case MAP: {
                return new GenericAccessor(vector);
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to find sql accessor for minor type [%s]", new Object[]{type}));
    }
}

