/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.AbstractSqlAccessor;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeStampMilliVector;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeStampMilliAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.TIMESTAMPMILLI);
    private final TimeZone defaultTimeZone;
    private final TimeStampMilliVector ac;

    public TimeStampMilliAccessor(TimeStampMilliVector vector, TimeZone defaultTZ) {
        this.ac = vector;
        this.defaultTimeZone = Preconditions.checkNotNull(defaultTZ, "Null TimeZone supplied.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getTimestamp(index, this.defaultTimeZone);
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar calendar) {
        Preconditions.checkNotNull(calendar, "Invalid calendar used when attempting to retrieve timestamp.");
        return this.getTimestamp(index, calendar.getTimeZone());
    }

    private Timestamp getTimestamp(int index, TimeZone tz) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDateTime ldt = this.ac.getObject(index);
        if (tz != this.defaultTimeZone) {
            long arrowMillis = this.ac.get(index);
            ldt = ldt.minus(tz.getOffset(arrowMillis) - this.defaultTimeZone.getOffset(arrowMillis), ChronoUnit.MILLIS);
        }
        return Timestamp.valueOf(ldt);
    }
}

