/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.common.util.DremioStringUtils;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.AbstractSqlAccessor;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBufInputStream;
import com.dremio.jdbc.shaded.io.netty.buffer.NettyArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VarBinaryVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import java.io.InputStream;

public class VarBinaryAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VARBINARY);
    private final VarBinaryVector ac;

    public VarBinaryAccessor(VarBinaryVector vector) {
        this.ac = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return byte[].class;
    }

    @Override
    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    @Override
    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVarBinaryHolder h2 = new NullableVarBinaryHolder();
        this.ac.get(index, h2);
        return new ByteBufInputStream(NettyArrowBuf.unwrapBuffer(h2.buffer.slice(h2.start, h2.end)));
    }

    @Override
    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    @Override
    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        byte[] b = this.ac.get(index);
        return DremioStringUtils.toBinaryString(b);
    }
}

