/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.accessor.AbstractSqlAccessor;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBufInputStream;
import com.dremio.jdbc.shaded.io.netty.buffer.NettyArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VarCharVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableVarCharHolder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class VarCharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    private final VarCharVector ac;

    public VarCharAccessor(VarCharVector vector) {
        this.ac = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVarCharHolder h2 = new NullableVarCharHolder();
        this.ac.get(index, h2);
        return new ByteBufInputStream(NettyArrowBuf.unwrapBuffer(h2.buffer.slice(h2.start, h2.end)));
    }

    @Override
    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public String getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getString(index);
    }

    @Override
    public InputStreamReader getReader(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new InputStreamReader(this.getStream(index), StandardCharsets.UTF_8);
    }

    @Override
    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new String(this.getBytes(index), StandardCharsets.UTF_8);
    }
}

