/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.vector.complex.fn;

import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.common.expression.PathSegment;
import com.dremio.jdbc.shaded.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class FieldSelection {
    public static final FieldSelection INVALID_NODE = new FieldSelection(null, ValidityMode.NEVER_VALID);
    public static final FieldSelection ALL_VALID = new FieldSelection(null, ValidityMode.ALWAYS_VALID);
    private final Map<String, FieldSelection> children;
    private final Map<String, FieldSelection> childrenInsensitive;
    private ValidityMode mode;

    private FieldSelection() {
        this(new HashMap<String, FieldSelection>(), ValidityMode.CHECK_CHILDREN);
    }

    private FieldSelection(Map<String, FieldSelection> children, ValidityMode mode) {
        this.children = children;
        if (children != null) {
            this.childrenInsensitive = new TreeMap<String, FieldSelection>(String.CASE_INSENSITIVE_ORDER);
            this.childrenInsensitive.putAll(children);
        } else {
            this.childrenInsensitive = null;
        }
        this.mode = mode;
    }

    public String toString() {
        return super.toString() + "[mode = " + String.valueOf((Object)this.mode) + ", children = " + String.valueOf(this.children) + ", childrenInsensitive = " + String.valueOf(this.childrenInsensitive) + "]";
    }

    private FieldSelection fixNodes() {
        if (this.children.isEmpty()) {
            return ALL_VALID;
        }
        HashMap<String, FieldSelection> newMap = Maps.newHashMap();
        for (Map.Entry<String, FieldSelection> e : this.children.entrySet()) {
            newMap.put(e.getKey(), e.getValue().fixNodes());
        }
        return new FieldSelection(newMap, this.mode);
    }

    private FieldSelection addChild(String name) {
        if (this.children.containsKey(name = name.toLowerCase())) {
            return this.children.get(name);
        }
        FieldSelection n = new FieldSelection();
        this.children.put(name, n);
        return n;
    }

    private void add(PathSegment segment) {
        if (segment.getType().equals((Object)PathSegment.PathSegmentType.NAME)) {
            boolean lastPath = segment.isLastPath();
            FieldSelection child = this.addChild(segment.getNameSegment().getPath());
            if (lastPath) {
                child.setAlwaysValid();
            }
            if (!lastPath && !child.isAlwaysValid()) {
                child.add(segment.getChild());
            }
        }
    }

    public boolean isNeverValid() {
        return this.mode == ValidityMode.NEVER_VALID;
    }

    private void setAlwaysValid() {
        this.mode = ValidityMode.ALWAYS_VALID;
    }

    public boolean isAlwaysValid() {
        return this.mode == ValidityMode.ALWAYS_VALID;
    }

    public FieldSelection getChild(String name) {
        switch (this.mode.ordinal()) {
            case 2: {
                return ALL_VALID;
            }
            case 0: {
                FieldSelection n = this.children.get(name);
                if (n == null && (n = this.childrenInsensitive.get(name)) != null) {
                    this.children.put(name, n);
                }
                if (n == null) {
                    return INVALID_NODE;
                }
                return n;
            }
            case 1: {
                return INVALID_NODE;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean containsStar(List<? extends BasePath> columns) {
        for (BasePath basePath : columns) {
            if (!basePath.getRootSegment().getPath().equals("*")) continue;
            return true;
        }
        return false;
    }

    public static FieldSelection getFieldSelection(List<? extends BasePath> fields) {
        if (FieldSelection.containsStar(fields)) {
            return ALL_VALID;
        }
        if (fields.size() == 0) {
            return INVALID_NODE;
        }
        FieldSelection root = new FieldSelection();
        for (BasePath basePath : fields) {
            root.add(basePath.getRootSegment());
        }
        return root.fixNodes();
    }

    private static enum ValidityMode {
        CHECK_CHILDREN,
        NEVER_VALID,
        ALWAYS_VALID;

    }
}

