/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io;

import com.dremio.jdbc.shaded.com.dremio.io.FSInputStream;
import com.dremio.jdbc.shaded.com.google.common.primitives.Ints;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.NettyArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ArrowBufFSInputStream
extends FSInputStream {
    private final ByteBuf nettyBuf;
    private final int startIndex;
    private final int endIndex;
    private boolean closed = false;

    public ArrowBufFSInputStream(ArrowBuf buf) {
        this.nettyBuf = NettyArrowBuf.unwrapBuffer(buf);
        this.startIndex = this.nettyBuf.readerIndex();
        this.endIndex = this.startIndex + this.nettyBuf.readableBytes();
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        return this.nettyBuf.readByte();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int available = this.available();
        if (available <= 0) {
            return -1;
        }
        int toRead = Math.min(len, available);
        this.nettyBuf.readBytes(b, off, toRead);
        return toRead;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int available = this.available();
        if (available <= 0) {
            return -1;
        }
        int toRead = Math.min(available, dst.remaining());
        ByteBuffer tmpBuf = dst.slice().limit(toRead);
        this.nettyBuf.readBytes(tmpBuf);
        dst.position(dst.position() + toRead);
        return toRead;
    }

    @Override
    public int read(long position, ByteBuffer dst) throws IOException {
        this.setPosition(position);
        return this.read(dst);
    }

    @Override
    public long getPosition() throws IOException {
        return this.nettyBuf.readerIndex() - this.startIndex;
    }

    @Override
    public void setPosition(long position) throws IOException {
        long newPosition = (long)this.startIndex + position;
        if (newPosition > (long)this.endIndex) {
            throw new EOFException("Cannot move past end of buffer");
        }
        this.nettyBuf.readerIndex((int)newPosition);
    }

    @Override
    public long skip(long n) throws IOException {
        int toSkip = Ints.saturatedCast(Math.min((long)this.available(), n));
        if (toSkip <= 0) {
            return 0L;
        }
        this.nettyBuf.skipBytes(toSkip);
        return toSkip;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.nettyBuf.markReaderIndex();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.nettyBuf.resetReaderIndex();
    }

    @Override
    public int available() throws IOException {
        return this.endIndex - this.nettyBuf.readerIndex();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.nettyBuf.release();
    }
}

