/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.ErrorHelper;
import com.dremio.jdbc.shaded.com.dremio.io.AsyncByteReader;
import com.dremio.jdbc.shaded.com.dremio.io.ReusableAsyncByteReader;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class AsyncByteReaderWithTimeout
extends ReusableAsyncByteReader {
    private static final Logger logger = LoggerFactory.getLogger(AsyncByteReaderWithTimeout.class);
    private static final ScheduledThreadPoolExecutor delayer;
    private final AtomicInteger numOutstandingReads = new AtomicInteger(0);
    private final AsyncByteReader inner;
    private final long timeoutInMillis;
    private static final AtomicLong totalTimeoutTasksScheduled;
    private static final AtomicLong totalTimeoutTasksCompleted;
    private static final AtomicLong totalTimeoutTasksCancelled;

    public AsyncByteReaderWithTimeout(AsyncByteReader inner, long timeoutInMillis, int delayerThreadCount) {
        this.inner = inner;
        this.timeoutInMillis = timeoutInMillis;
        delayer.setCorePoolSize(delayerThreadCount);
    }

    @Override
    public CompletableFuture<Void> readFully(long offset, ByteBuf dst, int dstOffset, int len) {
        this.numOutstandingReads.getAndIncrement();
        CompletionStage<Void> future = AsyncByteReaderWithTimeout.within(this.inner.readFully(offset, dst, dstOffset, len), this.timeoutInMillis);
        future = future.whenComplete((result, throwable) -> {
            if (ErrorHelper.findWrappedCause(throwable, AsyncTimeoutException.class) != null) {
                dst.retain();
            }
            this.numOutstandingReads.getAndDecrement();
        });
        if (logger.isDebugEnabled()) {
            logger.debug(AsyncByteReaderWithTimeout.getThreadPoolStats());
        }
        return future;
    }

    private static <T> CompletableFuture<T> within(CompletableFuture<T> future, long millis) {
        totalTimeoutTasksScheduled.incrementAndGet();
        CompletableFuture timeout = new CompletableFuture();
        ScheduledFuture<?> timeoutTask = delayer.schedule(() -> {
            totalTimeoutTasksCompleted.incrementAndGet();
            timeout.completeExceptionally(new AsyncTimeoutException());
        }, millis, TimeUnit.MILLISECONDS);
        return ((CompletableFuture)future.applyToEither((CompletionStage)timeout, Function.identity())).whenComplete((x, y) -> {
            if (timeoutTask.cancel(true) && y == null) {
                totalTimeoutTasksCancelled.incrementAndGet();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(AsyncByteReaderWithTimeout.getThreadPoolStats());
            }
        });
    }

    @Override
    protected void onClose() throws Exception {
        this.inner.close();
    }

    @Override
    public List<AsyncByteReader.ReaderStat> getStats() {
        return this.inner.getStats();
    }

    @VisibleForTesting
    static String getThreadPoolStats() {
        if (delayer == null) {
            return "Thread pool not initialized";
        }
        return String.format("AsyncByteReaderWithTimeout ThreadPool Stats: queueSize=%d, activeThreads=%d, corePoolSize=%d, completedTasks=%d, totalTasks=%d, customScheduled=%d, customCompleted=%d, customCancelled=%d", delayer.getQueue().size(), delayer.getActiveCount(), delayer.getCorePoolSize(), delayer.getCompletedTaskCount(), delayer.getTaskCount(), totalTimeoutTasksScheduled.get(), totalTimeoutTasksCompleted.get(), totalTimeoutTasksCancelled.get());
    }

    static {
        totalTimeoutTasksScheduled = new AtomicLong(0L);
        totalTimeoutTasksCompleted = new AtomicLong(0L);
        totalTimeoutTasksCancelled = new AtomicLong(0L);
        delayer = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("timeoutAfter-%d").build());
        delayer.setRemoveOnCancelPolicy(true);
    }

    private static class AsyncTimeoutException
    extends TimeoutException {
        AsyncTimeoutException() {
        }
    }
}

