/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io.file;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.io.AsyncByteReader;
import com.dremio.jdbc.shaded.com.dremio.io.FSInputStream;
import com.dremio.jdbc.shaded.com.dremio.io.FSOutputStream;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileAttributes;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileBlockLocation;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileSystem;
import com.dremio.jdbc.shaded.com.dremio.io.file.FilterFileSystem;
import com.dremio.jdbc.shaded.com.dremio.io.file.Path;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class DistStorageMetadataPathRewritingFileSystem
extends FilterFileSystem {
    private final Path distStoragePath;
    private final FileSystem fs;
    public static final Set<String> METADATA_FILE_EXTENSIONS = new HashSet<String>(){
        {
            this.add(".json");
            this.add(".avro");
            this.add(".crc");
        }
    };
    private static final String METADATA_SUBDIRECTORY = "metadata";
    private static final Logger logger = LoggerFactory.getLogger(DistStorageMetadataPathRewritingFileSystem.class);

    public DistStorageMetadataPathRewritingFileSystem(FileSystem fs, Path distStoragePath) {
        super(fs);
        Preconditions.checkArgument(distStoragePath != null, "distributed storage should exist");
        this.distStoragePath = distStoragePath;
        this.fs = fs;
    }

    public Path getDistStoragePath() {
        return this.distStoragePath;
    }

    @Override
    public Path canonicalizePath(Path p) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(p);
        return super.canonicalizePath(updatedPath);
    }

    @Override
    public FSInputStream open(Path f) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.open(updatedPath);
    }

    @Override
    public FSOutputStream create(Path f) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.create(updatedPath);
    }

    @Override
    public FSOutputStream create(Path f, boolean overwrite) throws FileAlreadyExistsException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.create(updatedPath, overwrite);
    }

    @Override
    public FileAttributes getFileAttributes(Path f) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.getFileAttributes(updatedPath);
    }

    @Override
    public void setPermission(Path p, Set<PosixFilePermission> permissions) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(p);
        super.setPermission(updatedPath, permissions);
    }

    @Override
    public boolean mkdirs(Path f, Set<PosixFilePermission> permissions) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.mkdirs(updatedPath, permissions);
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.mkdirs(updatedPath);
    }

    @Override
    public DirectoryStream<FileAttributes> list(Path f) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.list(updatedPath);
    }

    @Override
    public DirectoryStream<FileAttributes> list(Path f, Predicate<Path> filter) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.list(updatedPath, filter);
    }

    @Override
    public AsyncByteReader getAsyncByteReader(AsyncByteReader.FileKey fileKey, Map<String, String> options) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(fileKey.getPath());
        AsyncByteReader.FileKey updatedFileKey = AsyncByteReader.FileKey.of(updatedPath, fileKey.getVersion(), fileKey.getFileType(), fileKey.getDatasetKey(), fileKey.getPluginUID().get());
        return super.getAsyncByteReader(updatedFileKey, options);
    }

    @Override
    public DirectoryStream<FileAttributes> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.listFiles(updatedPath, recursive);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(src);
        return super.rename(updatedPath, dst);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.delete(updatedPath, recursive);
    }

    @Override
    public boolean exists(Path f) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.exists(updatedPath);
    }

    @Override
    public boolean isDirectory(Path f) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.isDirectory(updatedPath);
    }

    @Override
    public boolean isFile(Path f) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(f);
        return super.isFile(updatedPath);
    }

    @Override
    public Path makeQualified(Path path) {
        Path updatedPath = this.rewritePathIfNecessary(path);
        return super.makeQualified(updatedPath);
    }

    @Override
    public Iterable<FileBlockLocation> getFileBlockLocations(Path p, long start, long len) throws IOException {
        Path updatedPath = this.rewritePathIfNecessary(p);
        return super.getFileBlockLocations(updatedPath, start, len);
    }

    @Override
    public void access(Path path, Set<AccessMode> mode) throws AccessControlException, FileNotFoundException, IOException {
        Path updatedPath = this.rewritePathIfNecessary(path);
        super.access(updatedPath, mode);
    }

    public Path rewritePathIfNecessary(Path originalPath) {
        URI updatedUri;
        if (originalPath == null || originalPath.getParent() == null || originalPath.toURI().getPath().equals(this.distStoragePath.toString())) {
            return originalPath;
        }
        String filename = originalPath.getName().toLowerCase();
        String parentName = originalPath.getParent().getName();
        if (filename.lastIndexOf(".") < 0 || !METADATA_SUBDIRECTORY.equals(parentName) || !METADATA_FILE_EXTENSIONS.contains(filename.substring(filename.lastIndexOf(".")))) {
            return originalPath;
        }
        Path metadataRootFolder = originalPath.getParent().getParent();
        if (metadataRootFolder == null) {
            return originalPath;
        }
        Path relativeOriginalPath = Objects.requireNonNull(metadataRootFolder.getParent()).relativize(originalPath);
        Path mergedPath = Path.mergePaths(this.distStoragePath, relativeOriginalPath);
        URI distStoreUri = this.fs.getUri();
        try {
            updatedUri = new URI(distStoreUri.getScheme(), distStoreUri.getAuthority(), mergedPath.toURI().getPath(), distStoreUri.getQuery(), distStoreUri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.warn("Metadata Path Relocation Failed", e);
            throw UserException.invalidMetadataError(e).message("Metadata Path Relocation Failed").buildSilently();
        }
        return Path.of(updatedUri);
    }
}

