/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io.file;

import com.dremio.jdbc.shaded.com.dremio.io.AsyncByteReader;
import com.dremio.jdbc.shaded.com.dremio.io.FSInputStream;
import com.dremio.jdbc.shaded.com.dremio.io.FSOutputStream;
import com.dremio.jdbc.shaded.com.dremio.io.file.BoostedFileSystem;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileAttributes;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileBlockLocation;
import com.dremio.jdbc.shaded.com.dremio.io.file.Path;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public interface FileSystem
extends Closeable {
    public FSInputStream open(Path var1) throws FileNotFoundException, IOException;

    public String getScheme();

    public FSOutputStream create(Path var1) throws FileNotFoundException, IOException;

    public FSOutputStream create(Path var1, boolean var2) throws FileAlreadyExistsException, IOException;

    public FileAttributes getFileAttributes(Path var1) throws FileNotFoundException, IOException;

    public void setPermission(Path var1, Set<PosixFilePermission> var2) throws FileNotFoundException, IOException;

    public <T> T unwrap(Class<T> var1);

    public boolean mkdirs(Path var1, Set<PosixFilePermission> var2) throws IOException;

    public boolean mkdirs(Path var1) throws IOException;

    public DirectoryStream<FileAttributes> list(Path var1) throws FileNotFoundException, IOException;

    public DirectoryStream<FileAttributes> list(Path var1, Predicate<Path> var2) throws FileNotFoundException, IOException;

    public DirectoryStream<FileAttributes> listFiles(Path var1, boolean var2) throws FileNotFoundException, IOException;

    public DirectoryStream<FileAttributes> glob(Path var1, Predicate<Path> var2) throws FileNotFoundException, IOException;

    public boolean rename(Path var1, Path var2) throws IOException;

    public boolean delete(Path var1, boolean var2) throws IOException;

    public boolean exists(Path var1) throws IOException;

    public boolean isDirectory(Path var1) throws IOException;

    public boolean isFile(Path var1) throws IOException;

    public URI getUri();

    public Path makeQualified(Path var1);

    public Iterable<FileBlockLocation> getFileBlockLocations(FileAttributes var1, long var2, long var4) throws IOException;

    public Iterable<FileBlockLocation> getFileBlockLocations(Path var1, long var2, long var4) throws IOException;

    public void access(Path var1, Set<AccessMode> var2) throws AccessControlException, FileNotFoundException, IOException;

    public boolean isPdfs();

    public boolean isMapRfs();

    public boolean supportsBlockAffinity();

    public boolean supportsPath(Path var1);

    public long getDefaultBlockSize(Path var1);

    public Path canonicalizePath(Path var1) throws IOException;

    public boolean supportsAsync();

    public AsyncByteReader getAsyncByteReader(AsyncByteReader.FileKey var1, Map<String, String> var2) throws IOException;

    default public boolean preserveBlockLocationsOrder() {
        return false;
    }

    default public boolean supportsBoosting() {
        return false;
    }

    default public BoostedFileSystem getBoostedFilesystem() {
        Preconditions.checkArgument(this.supportsBoosting(), "FileSystem does not support boosting.");
        return null;
    }

    default public boolean supportsPathsWithScheme() {
        return true;
    }
}

