/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io.file;

import com.dremio.jdbc.shaded.com.dremio.io.CompressionCodec;
import com.dremio.jdbc.shaded.com.dremio.io.CompressionCodecFactory;
import com.dremio.jdbc.shaded.com.dremio.io.FSInputStream;
import com.dremio.jdbc.shaded.com.dremio.io.FSOutputStream;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileAttributes;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileSystem;
import com.dremio.jdbc.shaded.com.dremio.io.file.FilterDirectoryStream;
import com.dremio.jdbc.shaded.com.dremio.io.file.Path;
import com.dremio.jdbc.shaded.com.dremio.io.file.RecursiveDirectoryStream;
import com.dremio.jdbc.shaded.com.google.common.collect.Iterators;
import com.dremio.jdbc.shaded.com.google.common.io.ByteStreams;
import com.dremio.jdbc.shaded.com.google.common.io.Closeables;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

public final class FileSystemUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemUtils.class);
    private static final Queue<DeleteEntry> TO_DELETE_ON_EXIT = new ConcurrentLinkedQueue<DeleteEntry>();

    private FileSystemUtils() {
    }

    public static Object deleteOnExit(FileSystem fs, Path path) {
        DeleteEntry key = new DeleteEntry(fs, path);
        TO_DELETE_ON_EXIT.add(key);
        return key;
    }

    public static void cancelDeleteOnExit(Object key) {
        TO_DELETE_ON_EXIT.remove(key);
    }

    public static OutputStream create(FileSystem fs, Path file, Set<PosixFilePermission> permissions) throws IOException {
        FSOutputStream out = fs.create(file);
        try {
            fs.setPermission(file, permissions);
        }
        catch (IOException e) {
            Closeables.close(out, true);
            throw e;
        }
        return out;
    }

    public static FSInputStream openPossiblyCompressedStream(CompressionCodecFactory factory, FileSystem fs, Path path) throws IOException {
        CompressionCodec codec = factory.getCodec(path);
        if (codec != null) {
            return codec.newInputStream(fs.open(path));
        }
        return fs.open(path);
    }

    public static DirectoryStream<FileAttributes> listRecursive(FileSystem fs, Path path, Predicate<Path> pathFilter) throws IOException {
        DirectoryStream<FileAttributes> stream = fs.list(path, pathFilter);
        return new RecursiveDirectoryStream(fs, stream, pathFilter);
    }

    public static DirectoryStream<FileAttributes> globRecursive(FileSystem wrapper, Path pattern, Predicate<Path> filter) throws IOException {
        DirectoryStream<FileAttributes> globStream = wrapper.glob(pattern, filter);
        return new RecursiveDirectoryStream(wrapper, globStream, filter);
    }

    public static DirectoryStream<FileAttributes> listFilterDirectoryRecursive(FileSystem fs, Path path, final int maxFilesLimit, Predicate<Path> pathFilter) throws IOException {
        DirectoryStream<FileAttributes> baseIterator = FileSystemUtils.listRecursive(fs, path, pathFilter);
        if (maxFilesLimit <= 0) {
            return baseIterator;
        }
        return new FilterDirectoryStream<FileAttributes>(baseIterator){

            @Override
            public Iterator<FileAttributes> iterator() {
                return Iterators.limit(super.iterator(), maxFilesLimit);
            }
        };
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource) throws IOException {
        return FileSystemUtils.copy(srcFS, src, dstFS, dst, deleteSource, true);
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite) throws IOException {
        FileAttributes fileAttributes = srcFS.getFileAttributes(src);
        return FileSystemUtils.copy(srcFS, fileAttributes, dstFS, dst, deleteSource, overwrite);
    }

    public static boolean copy(FileSystem srcFS, FileAttributes srcAttributes, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite) throws IOException {
        Path src = srcAttributes.getPath();
        dst = FileSystemUtils.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcAttributes.isDirectory()) {
            FileSystemUtils.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            try (DirectoryStream<FileAttributes> contents = srcFS.list(src);){
                for (FileAttributes content : contents) {
                    FileSystemUtils.copy(srcFS, content, dstFS, dst.resolve(content.getPath().getName()), deleteSource, overwrite);
                }
            }
        }
        try (FSInputStream in = srcFS.open(src);
             FSOutputStream out = dstFS.create(dst, overwrite);){
            ByteStreams.copy(in, out);
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileAttributes sdst = dstFS.getFileAttributes(dst);
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + String.valueOf(dst) + " is a directory");
                }
                return FileSystemUtils.checkDest(null, dstFS, dst.resolve(srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + String.valueOf(dst) + " already exists");
            }
        }
        return dst;
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = srcFS.makeQualified(src).toString() + "/";
            String dstq = dstFS.makeQualified(dst).toString() + "/";
            if (dstq.startsWith(srcq)) {
                if (srcq.length() == dstq.length()) {
                    throw new IOException("Cannot copy " + String.valueOf(src) + " to itself.");
                }
                throw new IOException("Cannot copy " + String.valueOf(src) + " to its subdirectory " + String.valueOf(dst));
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("files-delete-on-exit"){

            @Override
            public void run() {
                DeleteEntry entry = TO_DELETE_ON_EXIT.poll();
                while (entry != null) {
                    try {
                        entry.fs.delete(entry.path, true);
                    }
                    catch (IOException | IllegalStateException e) {
                        LOGGER.warn("Could not delete path {}", (Object)entry.path, (Object)e);
                    }
                    entry = TO_DELETE_ON_EXIT.poll();
                }
            }
        });
    }

    private static class DeleteEntry {
        private final FileSystem fs;
        private final Path path;

        public DeleteEntry(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }
    }
}

