/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io.file;

import com.dremio.jdbc.shaded.com.dremio.io.file.UriSchemes;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class Path
implements Comparable<Path> {
    public static final String AZURE_BLOB_AUTHORITY_SUFFIX = ".blob.core.windows.net";
    public static final String AZURE_DFS_AUTHORITY_SUFFIX = ".dfs.core.windows.net";
    public static final String CONTAINER_SEPARATOR = "@";
    public static final Set<String> S3_FILE_SYSTEM = ImmutableSet.of("s3a", "s3", "s3n");
    public static final Set<String> GCS_FILE_SYSTEM = ImmutableSet.of("gs");
    public static final Set<String> AZURE_FILE_SYSTEM = ImmutableSet.of("wasbs", "wasb", "abfs", "abfss");
    public static final Set<Object> validSchemes = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(S3_FILE_SYSTEM)).addAll(GCS_FILE_SYSTEM)).addAll(AZURE_FILE_SYSTEM)).addAll((Iterable)Arrays.stream(UriSchemes.class.getFields()).map(x -> {
        try {
            return x.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "";
        }
    }).collect(Collectors.toList()))).build();
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    private static final Path CURRENT_DIRECTORY = Path.of(".");
    private final URI uri;

    private Path(URI uri) {
        this.uri = Objects.requireNonNull(uri).normalize();
        Preconditions.checkArgument(this.uri.getPath() != null, "Path URI requires a path component");
    }

    public static Path of(URI uri) {
        return new Path(uri);
    }

    public static Path of(String path) {
        Objects.requireNonNull(path);
        Preconditions.checkArgument(!path.isEmpty(), "path should be a non-empty string");
        return Path.of(Path.toURI(path));
    }

    public static Path mergePaths(Path path1, Path path2) {
        String path1Path = path1.uri.getPath();
        String path2Path = path2.uri.getPath();
        if (path2Path.isEmpty()) {
            return path1;
        }
        StringBuilder finalPath = new StringBuilder(path1Path.length() + path2Path.length() + 1);
        finalPath.append(path1Path);
        if (!path1Path.isEmpty() && path1Path.charAt(path1Path.length() - 1) != '/') {
            finalPath.append('/');
        }
        if (path2Path.charAt(0) != '/') {
            finalPath.append(path2Path);
        } else {
            finalPath.append(path2Path.substring(1));
        }
        try {
            return Path.of(new URI(path1.uri.getScheme(), path1.uri.getAuthority(), finalPath.toString(), null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException();
        }
    }

    public static Path withoutSchemeAndAuthority(Path path) {
        Objects.requireNonNull(path);
        URI uri = path.toURI();
        if (uri.getScheme() == null && uri.getAuthority() == null) {
            return path;
        }
        try {
            return Path.of(new URI(null, null, uri.getPath(), null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String getName() {
        String path = this.uri.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public Path getParent() {
        String path = this.uri.getPath();
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return CURRENT_DIRECTORY;
        }
        if (index == 0) {
            if (path.length() == 1) {
                return null;
            }
            return Path.of(SEPARATOR);
        }
        String parent = path.substring(0, index);
        try {
            return new Path(new URI(this.uri.getScheme(), this.uri.getAuthority(), parent, null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException();
        }
    }

    public Path resolve(Path path) {
        Path that = Objects.requireNonNull(path);
        if (that.uri.isAbsolute() || that.isAbsolute()) {
            return that;
        }
        String thatPath = that.uri.getPath();
        if (thatPath.isEmpty()) {
            return this;
        }
        String thisPath = this.uri.getPath();
        StringBuilder finalPath = new StringBuilder(thisPath.length() + thatPath.length() + 1);
        finalPath.append(thisPath);
        if (!thisPath.isEmpty() && thisPath.charAt(thisPath.length() - 1) != '/') {
            finalPath.append('/');
        }
        finalPath.append(thatPath);
        try {
            return Path.of(new URI(this.uri.getScheme(), this.uri.getAuthority(), finalPath.toString(), null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Path resolve(String path) {
        Objects.requireNonNull(path);
        return this.resolve(Path.of(path));
    }

    public boolean isAbsolute() {
        return this.uri.getPath().startsWith(SEPARATOR);
    }

    public int depth() {
        String path = this.uri.getPath();
        if (path.charAt(0) == '/' && path.length() == 1) {
            return 0;
        }
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public URI toURI() {
        return this.uri;
    }

    public Path relativize(Path that) {
        return Path.of(this.uri.relativize(that.uri));
    }

    public String toString() {
        return Path.toString(this);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path that = (Path)obj;
        return this.uri.equals(that.uri);
    }

    @Override
    public int compareTo(Path that) {
        return this.uri.compareTo(that.uri);
    }

    public static URI toURI(String uri) {
        String authority;
        String scheme;
        int colonIndexOf = uri.indexOf(58);
        int slashIndexOf = uri.indexOf(47);
        int start = 0;
        if (colonIndexOf >= 0 && (slashIndexOf == -1 || slashIndexOf > colonIndexOf)) {
            scheme = uri.substring(0, colonIndexOf);
            start = colonIndexOf + 1;
        } else {
            scheme = null;
        }
        if (uri.startsWith("//", start)) {
            int rootSlashIndexOf = uri.indexOf(47, start + 2);
            if (rootSlashIndexOf > -1) {
                authority = uri.substring(start + 2, rootSlashIndexOf);
                start = rootSlashIndexOf;
            } else {
                authority = uri.substring(start + 2);
                start = uri.length();
            }
        } else {
            authority = null;
        }
        if (scheme != null && !validSchemes.contains(scheme)) {
            try {
                URI uriPath = new URI(null, authority, SEPARATOR + uri, null, null);
                return URI.create(SEPARATOR).relativize(uriPath);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            return new URI(scheme, authority, uri.substring(start), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(Path path) {
        StringBuilder sb = new StringBuilder();
        URI uri = path.uri;
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme()).append(":");
        }
        if (uri.getAuthority() != null) {
            sb.append("//").append(uri.getAuthority());
        }
        if (uri.getPath() != null) {
            sb.append(uri.getPath());
        }
        return sb.toString();
    }

    public static String getContainerSpecificRelativePath(Path path) {
        URI pathUri = path.uri;
        if (pathUri.getScheme() == null) {
            return path.toString();
        }
        String scheme = pathUri.getScheme().toLowerCase(Locale.ROOT);
        if (S3_FILE_SYSTEM.contains(scheme)) {
            String bucketName = pathUri.getAuthority() != null ? pathUri.getAuthority() : "";
            return SEPARATOR + bucketName + pathUri.getPath();
        }
        if (AZURE_FILE_SYSTEM.contains(scheme)) {
            String containerName = pathUri.getUserInfo();
            return SEPARATOR + containerName + pathUri.getPath();
        }
        if (GCS_FILE_SYSTEM.contains(scheme)) {
            String bucketName = pathUri.getAuthority() != null ? pathUri.getAuthority() : "";
            return SEPARATOR + bucketName + pathUri.getPath();
        }
        if ("file".equals(scheme)) {
            return pathUri.getPath();
        }
        return path.toString();
    }
}

