/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.io.file;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileAttributes;
import com.dremio.jdbc.shaded.com.dremio.io.file.FileSystem;
import com.dremio.jdbc.shaded.com.dremio.io.file.Path;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

class RecursiveDirectoryStream
implements DirectoryStream<FileAttributes> {
    private final Stack<Map.Entry<DirectoryStream<FileAttributes>, Iterator<FileAttributes>>> iteratorsStack;
    private final FileSystem fileSystem;
    private final Predicate<Path> pathFilter;
    private final AtomicBoolean init = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public RecursiveDirectoryStream(@Nonnull FileSystem fileSystem, @Nonnull DirectoryStream<FileAttributes> stream, Predicate<Path> pathFilter) throws IOException {
        this.pathFilter = pathFilter;
        this.fileSystem = fileSystem;
        this.iteratorsStack = new Stack();
        this.pushToStack(stream);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            AutoCloseables.close(Iterables.transform(this.iteratorsStack, Map.Entry::getKey));
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<FileAttributes> iterator() {
        if (!this.init.compareAndSet(false, true)) {
            throw new IllegalStateException("Iterator already accessed.");
        }
        if (!this.closed.compareAndSet(false, true)) {
            throw new IllegalStateException("Directory stream already closed.");
        }
        return new Iterator<FileAttributes>(){
            private FileAttributes lastFetchedElement = null;

            @Override
            public boolean hasNext() {
                if (this.lastFetchedElement != null) {
                    return true;
                }
                while (!RecursiveDirectoryStream.this.iteratorsStack.empty()) {
                    Map.Entry<DirectoryStream<FileAttributes>, Iterator<FileAttributes>> currentEntry = RecursiveDirectoryStream.this.iteratorsStack.peek();
                    Iterator<FileAttributes> currentIterator = currentEntry.getValue();
                    if (!currentIterator.hasNext()) {
                        try {
                            RecursiveDirectoryStream.this.iteratorsStack.pop();
                            currentEntry.getKey().close();
                            continue;
                        }
                        catch (IOException e) {
                            throw new DirectoryIteratorException(e);
                        }
                    }
                    FileAttributes currentFileAttributes = currentIterator.next();
                    Path currentPath = currentFileAttributes.getPath();
                    if (!RecursiveDirectoryStream.this.pathFilter.test(currentPath)) continue;
                    this.lastFetchedElement = currentFileAttributes;
                    if (currentFileAttributes.isDirectory()) {
                        try {
                            RecursiveDirectoryStream.this.pushToStack(RecursiveDirectoryStream.this.fileSystem.list(currentPath, RecursiveDirectoryStream.this.pathFilter));
                        }
                        catch (IOException e) {
                            throw new DirectoryIteratorException(e);
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public FileAttributes next() {
                if (this.hasNext()) {
                    FileAttributes fileAttributes = this.lastFetchedElement;
                    this.lastFetchedElement = null;
                    return fileAttributes;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private void pushToStack(DirectoryStream<FileAttributes> stream) {
        this.iteratorsStack.push(new AbstractMap.SimpleEntry<DirectoryStream<FileAttributes>, Iterator<FileAttributes>>(stream, stream.iterator()));
    }

    @VisibleForTesting
    protected int getStackSize() {
        return this.iteratorsStack.size();
    }
}

