/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user;

import com.dremio.jdbc.shaded.com.dremio.exec.expr.TypeHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorContainer;
import com.dremio.jdbc.shaded.com.dremio.exec.record.WritableBatch;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.NettyArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.AllocationHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.SerializedFieldHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.List;

abstract class BaseBackwardsCompatibilityHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseBackwardsCompatibilityHandler.class);
    private final BufferAllocator allocator;

    BaseBackwardsCompatibilityHandler(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    protected BufferAllocator getAllocator() {
        return this.allocator;
    }

    protected ByteBuf[] sliceIfNecessary(QueryBatch batch) {
        ByteBuf[] buffers = batch.getBuffers();
        if (buffers != null && buffers.length != 1) {
            return buffers;
        }
        try (VectorContainer vc = new VectorContainer();){
            ArrowBuf buf = ((NettyArrowBuf)buffers[0]).arrowBuf();
            int bufOffset = 0;
            for (UserBitShared.SerializedField field : batch.getHeader().getDef().getFieldList()) {
                Field fieldDef = SerializedFieldHelper.create(field);
                FieldVector vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                if (field.getValueCount() == 0) {
                    AllocationHelper.allocate(vector, 0, 0, 0);
                } else {
                    TypeHelper.load(vector, field, buf.slice(bufOffset, field.getBufferLength()));
                }
                bufOffset += field.getBufferLength();
                vc.add(vector);
            }
            vc.buildSchema();
            vc.setAllCount(batch.getHeader().getRowCount());
            buf.close();
            ByteBuf[] byteBufArray = WritableBatch.get(vc).getBuffers();
            return byteBufArray;
        }
    }

    public QueryBatch makeBatchCompatible(QueryBatch batch) {
        UserBitShared.QueryData.Builder header = batch.getHeader().toBuilder();
        List<UserBitShared.SerializedField.Builder> fieldBuilders = header.getDefBuilder().getFieldBuilderList();
        ByteBuf[] buffers = this.sliceIfNecessary(batch);
        try {
            this.patchFields(fieldBuilders, buffers, 0, buffers.length, "$root$", "");
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failure patching batch for compatibility. schema: " + String.valueOf(batch.getHeader()) + " buffers: " + BaseBackwardsCompatibilityHandler.sizesString(buffers, 0, buffers.length), e);
        }
        UserBitShared.QueryData newHeader = header.build();
        return new QueryBatch(newHeader, buffers);
    }

    protected void patchFields(List<UserBitShared.SerializedField.Builder> fields, ByteBuf[] oldBuffers, int bufferStart, int buffersLength, String parentName, String indent) {
        Preconditions.checkArgument(bufferStart >= 0 && (oldBuffers.length == 0 && bufferStart == 0 || bufferStart < oldBuffers.length) && buffersLength >= 0 && bufferStart + buffersLength <= oldBuffers.length, "bufferStart: %s, buffersLength: %s, oldBuffers.length: %s", (Object)bufferStart, (Object)buffersLength, (Object)oldBuffers.length);
        if (logger.isDebugEnabled()) {
            logger.debug("{}fields: {}, buffers: {} for {}", indent, BaseBackwardsCompatibilityHandler.sizesString(fields), BaseBackwardsCompatibilityHandler.sizesString(oldBuffers, bufferStart, buffersLength), parentName);
        }
        int bufferIndex = bufferStart;
        int childBufferLength = buffersLength;
        for (UserBitShared.SerializedField.Builder field : fields) {
            int fieldBuffersLength = BaseBackwardsCompatibilityHandler.fieldBuffersCount(field, oldBuffers, bufferIndex, childBufferLength);
            this.patch(field, oldBuffers, bufferIndex, fieldBuffersLength, parentName, indent);
            bufferIndex += fieldBuffersLength;
            childBufferLength -= fieldBuffersLength;
        }
        while (bufferIndex < bufferStart + buffersLength && oldBuffers[bufferIndex].readableBytes() == 0) {
            ++bufferIndex;
        }
        if (bufferIndex != bufferStart + buffersLength) {
            throw new IllegalStateException("Fields (" + BaseBackwardsCompatibilityHandler.sizeTreeString(fields) + ") should have consumed all the buffers: " + BaseBackwardsCompatibilityHandler.sizesString(oldBuffers, bufferStart, buffersLength) + " " + bufferIndex + " != " + (bufferStart + buffersLength) + " parent: " + parentName);
        }
    }

    public abstract void patch(UserBitShared.SerializedField.Builder var1, ByteBuf[] var2, int var3, int var4, String var5, String var6);

    protected static String sizesString(ByteBuf[] buffers, int bufferStart, int buffersLength) {
        StringBuilder buffersSizes = new StringBuilder("#").append(bufferStart).append("/ ").append(buffersLength).append("[ ");
        for (int i = 0; i < buffersLength; ++i) {
            ByteBuf byteBuf = buffers[bufferStart + i];
            buffersSizes.append(byteBuf.readableBytes()).append(" ");
        }
        buffersSizes.append("]");
        return buffersSizes.toString();
    }

    protected static String sizesString(List<UserBitShared.SerializedField.Builder> fields) {
        StringBuilder fieldsString = new StringBuilder(" ");
        for (UserBitShared.SerializedField.Builder field : fields) {
            fieldsString.append(field.getBufferLength()).append(" ");
        }
        return fieldsString.toString();
    }

    protected static String sizeTreeString(List<UserBitShared.SerializedField.Builder> fields) {
        StringBuilder fieldsString = new StringBuilder("(");
        boolean first = true;
        for (UserBitShared.SerializedField.Builder field : fields) {
            if (first) {
                first = false;
            } else {
                fieldsString.append(", ");
            }
            fieldsString.append(field.getBufferLength());
            if (field.getChildCount() <= 0) continue;
            fieldsString.append(BaseBackwardsCompatibilityHandler.sizeTreeString(field.getChildBuilderList()));
        }
        fieldsString.append(")");
        return fieldsString.toString();
    }

    static int fieldBuffersCount(UserBitShared.SerializedField.Builder field, ByteBuf[] buffers, int buffersStart, int buffersLength) {
        int lastIndex;
        ByteBuf buf;
        int totalBufferWidth = 0;
        for (lastIndex = buffersStart; totalBufferWidth < field.getBufferLength() && lastIndex < buffersStart + buffersLength; totalBufferWidth += buf.readableBytes(), ++lastIndex) {
            buf = buffers[lastIndex];
        }
        if (totalBufferWidth != field.getBufferLength()) {
            throw new IllegalStateException("not enough buffers for field " + String.valueOf(field.build()) + " in " + BaseBackwardsCompatibilityHandler.sizesString(buffers, buffersStart, buffersLength) + " lastIndex = " + lastIndex + " bs=" + buffersStart + " bl = " + buffersLength + " " + totalBufferWidth + " != " + field.getBufferLength());
        }
        return lastIndex - buffersStart;
    }

    public void close() throws Exception {
        this.allocator.close();
    }

    static final class QueryBatch {
        private final UserBitShared.QueryData header;
        private final ByteBuf[] buffers;

        public QueryBatch(UserBitShared.QueryData header, ByteBuf ... buffers) {
            this.header = header;
            this.buffers = buffers;
            for (ByteBuf b : buffers) {
                Preconditions.checkNotNull(b);
            }
        }

        public ByteBuf[] getBuffers() {
            return this.buffers;
        }

        public long getByteCount() {
            long n = 0L;
            for (ByteBuf buf : this.buffers) {
                n += (long)buf.readableBytes();
            }
            return n;
        }

        public UserBitShared.QueryData getHeader() {
            return this.header;
        }

        public String toString() {
            return "QueryBatch [header=" + String.valueOf(this.header) + ", buffers=" + Arrays.toString(this.buffers) + "]";
        }
    }
}

