/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.BaseBackwardsCompatibilityHandler;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

class Dremio14BackwardCompatibilityHandler
extends BaseBackwardsCompatibilityHandler {
    private static final Logger logger = LoggerFactory.getLogger(Dremio14BackwardCompatibilityHandler.class);

    public Dremio14BackwardCompatibilityHandler(BufferAllocator bcAllocator) {
        super(bcAllocator);
    }

    @Override
    public void patch(UserBitShared.SerializedField.Builder field, ByteBuf[] buffers, int bufferStart, int buffersLength, String parentName, String indent) {
        TypeProtos.DataMode mode = field.getMajorType().getMode();
        TypeProtos.MinorType minor = field.getMajorType().getMinorType();
        String name = field.getNamePart().getName();
        boolean changed = false;
        if (logger.isDebugEnabled()) {
            logger.debug("{} BEFORE PATCH: buffers {} for field {}.{}: {} {} expecting {}", indent, Dremio14BackwardCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength), parentName, name, mode, minor, field.getBufferLength());
        }
        if (field.getValueCount() != 0 && mode == TypeProtos.DataMode.OPTIONAL) {
            while (buffers[bufferStart].readableBytes() == 0) {
                ++bufferStart;
                --buffersLength;
            }
        }
        if (mode == TypeProtos.DataMode.OPTIONAL && minor == TypeProtos.MinorType.MAP) {
            field.getMajorTypeBuilder().setMinorType(TypeProtos.MinorType.LIST);
            changed = true;
        }
        if (logger.isDebugEnabled() && changed) {
            logger.debug("{} AFTER PATCH: buffers {} for field {}.{}: {} {} expecting {}", indent, Dremio14BackwardCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength), parentName, name, mode, minor, field.getBufferLength());
        }
    }
}

