/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.BaseBackwardsCompatibilityHandler;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.NettyArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DecimalHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.DecimalUtility;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.util.List;

class DrillBackwardsCompatibilityHandler
extends BaseBackwardsCompatibilityHandler {
    private static final Logger logger = LoggerFactory.getLogger(DrillBackwardsCompatibilityHandler.class);
    public static final int NUMBER_DECIMAL_DIGITS = 6;

    DrillBackwardsCompatibilityHandler(BufferAllocator allocator) {
        super(allocator);
    }

    @Override
    public void patch(UserBitShared.SerializedField.Builder field, ByteBuf[] buffers, int bufferStart, int buffersLength, String parentName, String indent) {
        TypeProtos.DataMode mode = field.getMajorType().getMode();
        TypeProtos.MinorType minor = field.getMajorType().getMinorType();
        String name = field.getNamePart().getName();
        boolean changed = false;
        if (logger.isDebugEnabled()) {
            logger.debug("{} BEFORE PATCH: buffers {} for field {}.{}: {} {} expecting {}", indent, DrillBackwardsCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength), parentName, name, mode, minor, field.getBufferLength());
        }
        if ("$values$".equals(name)) {
            field.getNamePartBuilder().setName(parentName);
        }
        List<UserBitShared.SerializedField.Builder> children = field.getChildBuilderList();
        if (field.getValueCount() != 0) {
            if (mode == TypeProtos.DataMode.OPTIONAL) {
                while (buffers[bufferStart].readableBytes() == 0) {
                    ++bufferStart;
                    --buffersLength;
                }
                int bitsIndex = minor == TypeProtos.MinorType.LIST ? 1 : 0;
                UserBitShared.SerializedField.Builder bitsField = children.get(bitsIndex);
                NettyArrowBuf bitsBuffer = (NettyArrowBuf)buffers[bufferStart + bitsIndex];
                if (bitsField.getMajorType().getMinorType() != TypeProtos.MinorType.BIT || !"$bits$".equals(bitsField.getNamePart().getName()) || bitsField.getMajorType().getMode() != TypeProtos.DataMode.REQUIRED) {
                    throw new IllegalStateException("bit vector should be called $bits$ and have type REQUIRED BIT. Found field: " + String.valueOf(field.build()));
                }
                NettyArrowBuf newBuf = DrillBackwardsCompatibilityHandler.convertBitsToBytes(this.getAllocator(), bitsField, bitsBuffer);
                buffers[bufferStart + bitsIndex] = newBuf;
                changed = true;
                if (minor == TypeProtos.MinorType.DECIMAL) {
                    ByteBuf newBuffer;
                    boolean decimalBufferIndex = true;
                    UserBitShared.SerializedField.Builder decimalField = children.get(1);
                    NettyArrowBuf decimalBuffer = (NettyArrowBuf)buffers[bufferStart + 1];
                    if (decimalField.getMajorType().getMinorType() != TypeProtos.MinorType.DECIMAL || decimalField.getMajorType().getMode() != TypeProtos.DataMode.REQUIRED) {
                        throw new IllegalStateException("Found incorrect decimal field: " + String.valueOf(field.build()));
                    }
                    buffers[bufferStart + 1] = newBuffer = DrillBackwardsCompatibilityHandler.patchDecimal(this.getAllocator(), decimalBuffer, field, decimalField);
                }
                if (minor == TypeProtos.MinorType.MAP) {
                    field.getMajorTypeBuilder().setMinorType(TypeProtos.MinorType.LIST);
                }
            }
            if (minor == TypeProtos.MinorType.INTERVALDAY && mode == TypeProtos.DataMode.REQUIRED) {
                NettyArrowBuf newBuf = DrillBackwardsCompatibilityHandler.padValues(this.getAllocator(), field, buffers[bufferStart], 8, 12);
                buffers[bufferStart] = newBuf;
            }
        } else if (mode == TypeProtos.DataMode.OPTIONAL && minor == TypeProtos.MinorType.MAP) {
            field.getMajorTypeBuilder().setMinorType(TypeProtos.MinorType.LIST);
            changed = true;
        }
        if (children.size() > 0) {
            if ((minor == TypeProtos.MinorType.VARCHAR || minor == TypeProtos.MinorType.VARBINARY) && mode == TypeProtos.DataMode.REQUIRED) {
                int newBuffersLength;
                int childrenBufferLength = 0;
                for (UserBitShared.SerializedField.Builder child : children) {
                    childrenBufferLength += child.getBufferLength();
                }
                if (childrenBufferLength == field.getBufferLength()) {
                    newBuffersLength = buffersLength;
                } else {
                    newBuffersLength = buffersLength - 1;
                    if (childrenBufferLength + buffers[bufferStart + newBuffersLength].readableBytes() != field.getBufferLength()) {
                        throw new IllegalStateException("bufferLength mismatch for field " + String.valueOf(field.build()) + " children: " + DrillBackwardsCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength));
                    }
                }
                this.patchFields(children, buffers, bufferStart, newBuffersLength, name, indent + "  ");
            } else {
                this.patchFields(children, buffers, bufferStart, buffersLength, name, indent + "  ");
            }
        }
        int bufferLength = 0;
        for (int i = 0; i < buffersLength; ++i) {
            ByteBuf buffer = buffers[i + bufferStart];
            bufferLength += buffer.readableBytes();
        }
        if (field.getBufferLength() != bufferLength) {
            field.setBufferLength(bufferLength);
            changed = true;
        }
        if (logger.isDebugEnabled() && changed) {
            logger.debug("{} AFTER PATCH: buffers {} for field {}.{}: {} {} expecting {}", indent, DrillBackwardsCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength), parentName, name, mode, minor, field.getBufferLength());
        }
    }

    static NettyArrowBuf convertBitsToBytes(BufferAllocator allocator, UserBitShared.SerializedField.Builder fieldBuilder, NettyArrowBuf oldBuf) {
        int valueCount = fieldBuilder.getValueCount();
        NettyArrowBuf newBuf = NettyArrowBuf.unwrapBuffer(allocator.buffer(valueCount));
        for (int i = 0; i < valueCount; ++i) {
            int byteIndex = i >> 3;
            byte b = oldBuf.getByte(byteIndex);
            int bitIndex = i & 7;
            newBuf.setByte(i, Long.bitCount((long)b & 1L << bitIndex));
        }
        newBuf.writerIndex(valueCount);
        fieldBuilder.setMajorType(Types.required(TypeProtos.MinorType.UINT1));
        fieldBuilder.setBufferLength(valueCount);
        oldBuf.release();
        return newBuf;
    }

    static NettyArrowBuf padValues(BufferAllocator allocator, UserBitShared.SerializedField.Builder fieldBuilder, ByteBuf oldBuf, int originalTypeByteWidth, int targetTypeByteWidth) {
        if (targetTypeByteWidth <= originalTypeByteWidth) {
            throw new IllegalArgumentException("the target width must be larger than the original one. " + targetTypeByteWidth + " is not larger than " + originalTypeByteWidth);
        }
        if (oldBuf.readableBytes() % originalTypeByteWidth != 0) {
            throw new IllegalArgumentException("the buffer size must be a multiple of the type width. " + oldBuf.readableBytes() + " is not a multiple of " + originalTypeByteWidth);
        }
        int valueCount = oldBuf.readableBytes() / originalTypeByteWidth;
        int newBufferLength = targetTypeByteWidth * valueCount;
        NettyArrowBuf newBuf = NettyArrowBuf.unwrapBuffer(allocator.buffer(newBufferLength));
        for (int byteIndex = 0; byteIndex < originalTypeByteWidth; ++byteIndex) {
            for (int i = 0; i < valueCount; ++i) {
                int oldIndex = i * originalTypeByteWidth + byteIndex;
                int newIndex = i * targetTypeByteWidth + byteIndex;
                newBuf.setByte(newIndex, oldBuf.getByte(oldIndex));
            }
        }
        newBuf.writerIndex(newBufferLength);
        fieldBuilder.setBufferLength(newBufferLength);
        oldBuf.release();
        return newBuf;
    }

    static ByteBuf patchDecimal(BufferAllocator allocator, NettyArrowBuf dataBuffer, UserBitShared.SerializedField.Builder decimalField, UserBitShared.SerializedField.Builder childDecimalField) {
        int decimalLength = 16;
        int startPoint = dataBuffer.readerIndex();
        int valueCount = dataBuffer.readableBytes() / 16;
        NettyArrowBuf drillBuffer = NettyArrowBuf.unwrapBuffer(allocator.buffer(dataBuffer.readableBytes() + 8 * valueCount));
        int length = 0;
        for (int i = startPoint; i < startPoint + dataBuffer.readableBytes() - 1; i += 16) {
            BigDecimal arrowDecimal = DecimalUtility.getBigDecimalFromArrowBuf(dataBuffer.arrowBuf(), i / 16, decimalField.getMajorType().getScale(), 16);
            int startIndex = i == startPoint ? i : i + length;
            DecimalHelper.getSparseFromBigDecimal(arrowDecimal, drillBuffer, startIndex, decimalField.getMajorType().getScale(), 6);
            length += 8;
        }
        TypeProtos.MajorType.Builder majorTypeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL38SPARSE).setMode(TypeProtos.DataMode.OPTIONAL).setPrecision(decimalField.getMajorType().getPrecision()).setScale(decimalField.getMajorType().getScale());
        decimalField.setMajorType(majorTypeBuilder.build());
        decimalField.setBufferLength(decimalField.getBufferLength() + 8 * valueCount);
        ((ByteBuf)drillBuffer).writerIndex(dataBuffer.readableBytes() + 8 * valueCount);
        childDecimalField.setMajorType(Types.required(TypeProtos.MinorType.DECIMAL38SPARSE));
        childDecimalField.setBufferLength(childDecimalField.getBufferLength() + 8 * valueCount);
        dataBuffer.release();
        return drillBuffer;
    }
}

