/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.security;

import com.dremio.jdbc.shaded.com.dremio.config.DremioConfig;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableSet;
import com.dremio.jdbc.shaded.com.google.errorprone.annotations.FormatMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.Set;

public final class SecurityFolder {
    private static final String SECURITY_DIRECTORY = "security";
    public static final Set<PosixFilePermission> SECURITY_DIRECTORY_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    public static final Set<PosixFilePermission> SECURITY_FILE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
    private final Path securityDirectory;

    public static SecurityFolder of(DremioConfig config) throws GeneralSecurityException, IOException {
        String localWritePath = config.getString("paths.local");
        Path path = Paths.get(localWritePath, SECURITY_DIRECTORY);
        Files.createDirectories(path, PosixFilePermissions.asFileAttribute(SECURITY_DIRECTORY_PERMISSIONS));
        return new SecurityFolder(path);
    }

    private SecurityFolder(Path path) throws GeneralSecurityException, IOException {
        this.securityDirectory = SecurityFolder.checkDirectoryPermissions(path);
    }

    public boolean exists(String filename) {
        return Files.exists(this.securityDirectory.resolve(filename), new LinkOption[0]);
    }

    public static boolean exists(DremioConfig config, String filename) {
        String localWritePath = config.getString("paths.local");
        return Files.exists(Paths.get(localWritePath, SECURITY_DIRECTORY, filename), new LinkOption[0]);
    }

    public static boolean securityFolderExists(DremioConfig config) {
        String localWritePath = config.getString("paths.local");
        return Files.exists(Paths.get(localWritePath, SECURITY_DIRECTORY), new LinkOption[0]);
    }

    public Path resolve(String filename) {
        return this.securityDirectory.resolve(filename);
    }

    public Path getSecurityDirectory() {
        return this.securityDirectory;
    }

    public OutputStream newSecureOutputStream(String filename, OpenOption openOption) throws GeneralSecurityException, IOException {
        java.nio.file.OpenOption[] openOptionArray;
        Path filePath = this.securityDirectory.resolve(filename);
        boolean exists = Files.exists(filePath, new LinkOption[0]);
        if (!exists && openOption == OpenOption.NO_CREATE) {
            throw new NoSuchFileException(filePath.toString());
        }
        if (!exists) {
            SeekableByteChannel byteChannel = Files.newByteChannel(filePath, ImmutableSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), PosixFilePermissions.asFileAttribute(SECURITY_FILE_PERMISSIONS));
            return Channels.newOutputStream(byteChannel);
        }
        SecurityFolder.checkFilePermissions(filePath);
        if (openOption == OpenOption.CREATE_ONLY) {
            java.nio.file.OpenOption[] openOptionArray2 = new java.nio.file.OpenOption[3];
            openOptionArray2[0] = StandardOpenOption.CREATE_NEW;
            openOptionArray2[1] = StandardOpenOption.WRITE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.TRUNCATE_EXISTING;
        } else {
            java.nio.file.OpenOption[] openOptionArray3 = new java.nio.file.OpenOption[2];
            openOptionArray3[0] = StandardOpenOption.WRITE;
            openOptionArray = openOptionArray3;
            openOptionArray3[1] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        java.nio.file.OpenOption[] options = openOptionArray;
        return Files.newOutputStream(filePath, options);
    }

    public InputStream newSecureInputStream(String filename) throws GeneralSecurityException, IOException {
        Path filePath = this.securityDirectory.resolve(filename);
        SecurityFolder.checkFilePermissions(filePath);
        return Files.newInputStream(filePath, new java.nio.file.OpenOption[0]);
    }

    private static Path checkDirectoryPermissions(Path path) throws GeneralSecurityException, IOException {
        return SecurityFolder.checkPathPermissions(path, "Directory", SECURITY_DIRECTORY_PERMISSIONS);
    }

    private static Path checkFilePermissions(Path path) throws GeneralSecurityException, IOException {
        return SecurityFolder.checkPathPermissions(path, "File", SECURITY_FILE_PERMISSIONS);
    }

    private static Path checkPathPermissions(Path path, String fileType, Set<PosixFilePermission> permissionReference) throws GeneralSecurityException, IOException {
        Set<PosixFilePermission> permission = Files.getPosixFilePermissions(path, new LinkOption[0]);
        SecurityFolder.checkSecurity(permissionReference.equals(permission), "%s %s is not accessible to owner only", fileType, path);
        return path;
    }

    @FormatMethod
    private static void checkSecurity(boolean check, String message, Object ... args) throws GeneralSecurityException {
        if (!check) {
            throw new GeneralSecurityException(String.format(message, args));
        }
    }

    public static enum OpenOption {
        CREATE_OR_WRITE,
        CREATE_ONLY,
        NO_CREATE;

    }
}

