/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service;

import com.dremio.jdbc.shaded.com.dremio.common.DeferredException;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ScanResult;
import com.dremio.jdbc.shaded.com.dremio.service.BindingProvider;
import com.dremio.jdbc.shaded.com.dremio.service.Initializer;
import com.dremio.jdbc.shaded.com.dremio.service.Service;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Set;

public class InitializerRegistry
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(InitializerRegistry.class);
    private ScanResult scanResult;
    private BindingProvider provider;
    private ImmutableMap<Class<?>, Object> outputs;

    public InitializerRegistry() {
    }

    public InitializerRegistry(ScanResult scanResult, BindingProvider provider) {
        this.scanResult = scanResult;
        this.provider = provider;
    }

    protected void init(ScanResult scanResult, BindingProvider provider) {
        this.scanResult = scanResult;
        this.provider = provider;
    }

    public <T, X extends Initializer<T>> T get(Class<X> clazz) {
        Object obj = this.outputs.get(clazz);
        Preconditions.checkNotNull(obj, "No initializer with return value registered for %s.", (Object)clazz.getName());
        return (T)obj;
    }

    @Override
    public void start() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set<Class<Initializer>> functions = this.scanResult.getImplementations(Initializer.class);
        DeferredException ex = new DeferredException();
        for (Class<Initializer> functionClass : functions) {
            Initializer i;
            try {
                i = functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                ex.addException(new RuntimeException("Unable to load Initializer " + functionClass.getSimpleName(), e));
                continue;
            }
            try {
                Object inited = i.initialize(this.provider);
                if (inited == null) continue;
                builder.put(functionClass, inited);
            }
            catch (Exception e) {
                ex.addException(new RuntimeException("Unable to initialize Initializer " + functionClass.getSimpleName(), e));
            }
        }
        ex.throwAndClear();
        this.outputs = builder.build();
    }

    @Override
    public void close() throws Exception {
    }
}

