/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service;

import com.dremio.jdbc.shaded.com.dremio.service.Service;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class ServiceAutoStart {
    private ServiceAutoStart() {
    }

    public static <I extends Service, S extends I> I withAutoStart(Class<I> iface, S service) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (I)((Service)Proxy.newProxyInstance(classLoader, new Class[]{iface}, (InvocationHandler)new Handler(service)));
    }

    private static final class Handler
    implements InvocationHandler {
        private static final Method START_METHOD;
        private static final Method CLOSE_METHOD;
        private final Object service;
        private volatile boolean started = false;

        private Handler(Object service) {
            this.service = service;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (START_METHOD.equals(method)) {
                this.ensureStarted();
                return null;
            }
            if (CLOSE_METHOD.equals(method)) {
                if (this.started) {
                    return method.invoke(this.service, new Object[0]);
                }
                return null;
            }
            this.ensureStarted();
            return method.invoke(this.service, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureStarted() throws InvocationTargetException, IllegalAccessException {
            if (!this.started) {
                Handler handler = this;
                synchronized (handler) {
                    if (!this.started) {
                        this.started = true;
                        START_METHOD.invoke(this.service, new Object[0]);
                    }
                }
            }
        }

        static {
            try {
                START_METHOD = Service.class.getDeclaredMethod("start", new Class[0]);
                CLOSE_METHOD = AutoCloseable.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

