/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service;

import com.dremio.jdbc.shaded.com.dremio.service.BinderImpl;
import com.dremio.jdbc.shaded.com.dremio.service.BindingProvider;
import com.dremio.jdbc.shaded.com.dremio.service.Service;
import com.dremio.jdbc.shaded.com.dremio.service.ServiceRegistry;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.Iterables;
import java.util.Objects;

public class SingletonRegistry
extends BinderImpl
implements AutoCloseable {
    private final ServiceRegistry registry;

    public SingletonRegistry() {
        this(new ServiceRegistry());
    }

    @VisibleForTesting
    SingletonRegistry(ServiceRegistry registry) {
        this.registry = registry;
    }

    public void start() throws Exception {
        this.registry.start();
    }

    protected Iterable<Service> getServices() {
        return Iterables.unmodifiableIterable(this.registry.getServices());
    }

    public <S extends Service> S bindSelf(S service) {
        return this.bind((Class<IFACE>)service.getClass(), (IMPL)service);
    }

    public <A extends AutoCloseable> A bindSelf(A autoCloseable) {
        return this.bind((Class<IFACE>)autoCloseable.getClass(), (IMPL)autoCloseable);
    }

    public <IFACE extends Service, IMPL extends IFACE> IMPL bind(Class<IFACE> iface, IMPL service) {
        ServiceReference<IFACE> ref = SingletonRegistry.wrap(iface, service);
        super.bind(iface, ref);
        this.registry.register(ref);
        return service;
    }

    public <IFACE extends AutoCloseable, IMPL extends IFACE> IMPL bind(Class<IFACE> iface, IMPL autoCloseable) {
        CloseableReference<IFACE> ref = SingletonRegistry.wrap(iface, new CloseableAsService<IMPL>(autoCloseable));
        super.bind(iface, ref);
        this.registry.register(ref);
        return autoCloseable;
    }

    public <S extends Service> S replace(S service) {
        return this.replace((Class<IFACE>)service.getClass(), (IMPL)service);
    }

    public <A extends AutoCloseable> A replace(A autoCloseable) {
        return this.replace((Class<IFACE>)autoCloseable.getClass(), (IMPL)autoCloseable);
    }

    public <IFACE extends Service, IMPL extends IFACE> IMPL replace(Class<IFACE> iface, IMPL service) {
        ServiceReference<IFACE> ref = SingletonRegistry.wrap(iface, service);
        super.replace(iface, ref);
        this.registry.replace(ref);
        return service;
    }

    public <IFACE extends AutoCloseable, IMPL extends IFACE> IMPL replace(Class<IFACE> iface, IMPL autoCloseable) {
        CloseableReference<IFACE> ref = SingletonRegistry.wrap(iface, new CloseableAsService<IMPL>(autoCloseable));
        super.replace(iface, ref);
        this.registry.replace(ref);
        return autoCloseable;
    }

    @Override
    public void close() throws Exception {
        this.registry.close();
    }

    private static <S extends Service> ServiceReference<S> wrap(Class<S> iface, S obj) {
        return new ServiceReference<S>(iface, obj);
    }

    private static <A extends AutoCloseable> CloseableReference<A> wrap(Class<A> iface, CloseableAsService<A> closeable) {
        return new CloseableReference<A>(iface, closeable);
    }

    @VisibleForTesting
    static class ServiceReference<S extends Service>
    extends AbstractServiceReference<S> {
        public ServiceReference(Class<S> iface, S service) {
            super(iface, service);
        }

        @Override
        public BinderImpl.ResolverType getType() {
            return BinderImpl.ResolverType.SINGLETON;
        }

        @Override
        public Object get(BindingProvider provider) {
            return this.service;
        }
    }

    @VisibleForTesting
    static final class CloseableAsService<A extends AutoCloseable>
    implements Service {
        private final A c;

        private CloseableAsService(A c) {
            this.c = c;
        }

        @Override
        public void close() throws Exception {
            this.c.close();
        }

        @Override
        public void start() throws Exception {
        }

        @VisibleForTesting
        A getCloseable() {
            return this.c;
        }
    }

    @VisibleForTesting
    static class CloseableReference<A extends AutoCloseable>
    extends AbstractServiceReference<CloseableAsService<A>> {
        public CloseableReference(Class<A> iface, CloseableAsService<A> service) {
            super(iface, service);
        }

        @Override
        public BinderImpl.ResolverType getType() {
            return BinderImpl.ResolverType.SINGLETON;
        }

        @Override
        public Object get(BindingProvider provider) {
            return ((CloseableAsService)this.service).c;
        }
    }

    private static abstract class AbstractServiceReference<T extends Service>
    implements BinderImpl.Resolver,
    Service {
        protected final Class<?> iface;
        protected final T service;
        private volatile ServiceState state = ServiceState.INIT;

        public AbstractServiceReference(Class<?> iface, T service) {
            this.iface = iface;
            this.service = service;
        }

        @Override
        public synchronized void close() throws Exception {
            this.service.close();
            this.state = ServiceState.STOPPED;
        }

        @Override
        public synchronized void start() throws Exception {
            Preconditions.checkArgument(this.state == ServiceState.INIT, "Cannot start a service in state %s.", (Object)this.state.name());
            this.service.start();
            this.state = ServiceState.STARTED;
        }

        public int hashCode() {
            return this.iface.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AbstractServiceReference)) {
                return false;
            }
            AbstractServiceReference other = (AbstractServiceReference)obj;
            return Objects.equals(this.iface, other.iface);
        }

        @VisibleForTesting
        Class<?> getIface() {
            return this.iface;
        }

        @VisibleForTesting
        T getService() {
            return this.service;
        }

        public String toString() {
            return this.service.getClass().getSimpleName();
        }
    }

    private static enum ServiceState {
        INIT,
        STARTED,
        STOPPED;

    }
}

