/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator;

import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LostConnectionObserver;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.exceptions.PathExistsException;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.exceptions.PathMissingException;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface LinearizableHierarchicalStore {
    public void executeMulti(PathCommand[] var1) throws PathExistsException, PathMissingException;

    public void executeSingle(PathCommand var1) throws PathExistsException, PathMissingException;

    public byte[] getData(String var1) throws PathMissingException;

    public byte[] getData(String var1, CompletableFuture<Void> var2) throws PathMissingException;

    public boolean checkExists(String var1);

    public Stats getStats(String var1);

    public CompletableFuture<Void> whenDeleted(String var1) throws PathMissingException;

    public CompletableFuture<Void> whenCreated(String var1) throws PathExistsException;

    public List<String> getChildren(String var1, CompletableFuture<Void> var2) throws PathMissingException;

    public void registerLostConnectionObserver(LostConnectionObserver var1);

    public boolean electionPathExists(String var1);

    public static class PathCommand {
        private final CommandType commandType;
        private final String fullPath;
        private final byte[] data;
        private String returnValue;

        public PathCommand(CommandType commandType, String fullPath, byte[] data) {
            this.commandType = commandType;
            this.fullPath = fullPath;
            this.data = data;
            this.returnValue = null;
        }

        public PathCommand(CommandType commandType, String fullPath) {
            this(commandType, fullPath, null);
        }

        public CommandType getCommandType() {
            return this.commandType;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getReturnValue() {
            return this.returnValue;
        }

        public void setReturnValue(String returnValue) {
            this.returnValue = returnValue;
        }
    }

    public static interface Stats {
        public long getCreationTime();

        public long getLastModifiedTime();

        public int getNumChanges();

        public long getSessionId();
    }

    public static enum CommandType {
        CREATE_EPHEMERAL,
        CREATE_EPHEMERAL_SEQUENTIAL,
        CREATE_PERSISTENT,
        SET_DATA,
        DELETE;

    }
}

