/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator;

import com.dremio.jdbc.shaded.com.dremio.service.coordinator.CoordinatorLostHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LostConnectionObserver;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.TaskLeaderStatusListener;
import com.dremio.jdbc.shaded.org.apache.curator.framework.state.ConnectionState;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public interface ObservableConnectionLostHandler
extends CoordinatorLostHandle {
    public static final Supplier<CoordinatorLostHandle> OBSERVABLE_LOST_HANDLER = () -> new ObservableConnectionLostHandler(){
        private final List<LostConnectionObserver> connectionLostObservers = new CopyOnWriteArrayList<LostConnectionObserver>();
        private volatile boolean connectionLost = false;

        @Override
        public void attachObserver(LostConnectionObserver observer) {
            this.connectionLostObservers.add(observer);
        }

        @Override
        public void handleConnectionState(ConnectionState state) {
            if (this.connectionLostObservers.isEmpty()) {
                return;
            }
            if (!state.isConnected()) {
                this.connectionLostObservers.forEach(LostConnectionObserver::notifyLostConnection);
                this.connectionLost = true;
            } else if (this.connectionLost) {
                this.connectionLostObservers.forEach(LostConnectionObserver::notifyConnectionRegainedAfterLost);
                this.connectionLost = false;
            }
        }

        @Override
        public void handleMasterDown(TaskLeaderStatusListener listener) {
        }

        @Override
        public boolean stateLoggingEnabled() {
            return true;
        }
    };

    public void attachObserver(LostConnectionObserver var1);
}

