/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator;

import com.dremio.jdbc.shaded.com.dremio.config.DremioConfig;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ProjectConfig;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ProjectConfigStore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.proto.DataCredentials;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Provider;

public class ProjectConfigImpl
implements ProjectConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectConfigImpl.class);
    public static final String ACCELERATION_PLUGIN_SUB_PATH = "/accelerator";
    public static final String UPLOADS_PLUGIN_SUB_PATH = "/uploads";
    public static final String SCRATCH_PLUGIN_SUB_PATH = "/scratch";
    public static final String PROFILE_PLUGIN_SUB_PATH = "/profile";
    public static final String METADATA_PLUGIN_SUB_PATH = "/metadata";
    public static final String GANDIVA_PERSISTENT_CACHE_PLUGIN_SUB_PATH = "/gandiva";
    public static final String SYSTEM_ICEBERG_TABLES_PLUGIN_SUB_PATH = "/system_iceberg_tables";
    public static final String NODE_HISTORY_PLUGIN_SUB_PATH = "/node_history";
    private final Provider<DremioConfig> fileProvider;
    private final Provider<ProjectConfigStore> storeProvider;

    public ProjectConfigImpl(Provider<DremioConfig> fileProvider, Provider<ProjectConfigStore> storeProvider) {
        this.fileProvider = fileProvider;
        this.storeProvider = storeProvider;
    }

    @Override
    public ProjectConfig.DistPathConfig getAcceleratorConfig() {
        return this.getDistPathConfig("paths.accelerator", ACCELERATION_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getScratchConfig() {
        return this.getDistPathConfig("paths.scratch", SCRATCH_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getProfileConfig() {
        return this.getDistPathConfig("paths.profile", PROFILE_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getUploadsConfig() {
        return this.getDistPathConfig("paths.uploads", UPLOADS_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getMetadataConfig() {
        return this.getDistPathConfig("paths.metadata", METADATA_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getGandivaPersistentCacheConfig() {
        return this.getDistPathConfig("paths.gandiva", GANDIVA_PERSISTENT_CACHE_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getSystemIcebergTablesConfig() {
        return this.getDistPathConfig("paths.system_iceberg_tables", SYSTEM_ICEBERG_TABLES_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getNodeHistoryConfig() {
        return this.getDistPathConfig("paths.node_history", NODE_HISTORY_PLUGIN_SUB_PATH);
    }

    protected ProjectConfig.DistPathConfig getDistPathConfig(String pathString, String subPath) {
        URI path;
        ProjectConfigStore store = (ProjectConfigStore)this.storeProvider.get();
        DataCredentials dataCredentials = null;
        if (store.get() == null || !store.get().hasDistStoreConfig()) {
            path = ((DremioConfig)this.fileProvider.get()).getURI(pathString);
        } else {
            try {
                path = new URI(store.get().getDistStoreConfig().getPath() + subPath);
                LOGGER.info("Got dist path for {} from store {}. Uri {}", pathString, store.get().getDistStoreConfig().getPath(), path);
            }
            catch (URISyntaxException e) {
                path = ((DremioConfig)this.fileProvider.get()).getURI(pathString);
                LOGGER.error("Invalid dist path for {} in store {}. Uri {}", pathString, store.get().getDistStoreConfig().getPath(), path);
            }
            if (store.get().getDataCredentials().hasKeys()) {
                dataCredentials = DataCredentials.newBuilder().setKeys(store.get().getDataCredentials().getKeys()).build();
            } else if (store.get().getDataCredentials().hasDataRole()) {
                dataCredentials = DataCredentials.newBuilder().setDataRole(store.get().getDataCredentials().getDataRole()).build();
            } else if (store.get().getDataCredentials().hasClientAccess()) {
                dataCredentials = DataCredentials.newBuilder().setClientAccess(store.get().getDataCredentials().getClientAccess()).build();
            }
        }
        return new ProjectConfig.DistPathConfig(path, dataCredentials);
    }

    @Override
    public String getOrgId() {
        if (((ProjectConfigStore)this.storeProvider.get()).get() != null) {
            return ((ProjectConfigStore)this.storeProvider.get()).get().getOrgId();
        }
        return null;
    }
}

