/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterElectionManager;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterServiceSetManager;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionListener;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionRegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.RegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ServiceSet;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.TaskLeaderChangeListener;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.TaskLeaderStatusListener;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.CounterWithOutcome;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.TimeGauge;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.inject.Provider;

public class TaskLeaderElection
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TaskLeaderElection.class);
    private static final AtomicLong LAST_LEADER_ELECTION = new AtomicLong();
    private static final CounterWithOutcome LEADERSHIP_ELECTION_COUNTER;
    private static final long LEADER_UNAVAILABLE_DURATION_SECS = 600L;
    private final Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider;
    private final Provider<ClusterElectionManager> clusterElectionManagerProvider;
    private final TaskLeaderStatusListener taskLeaderStatusListener;
    private final String serviceName;
    private final AtomicReference<Long> leaseExpirationTime = new AtomicReference<Object>(null);
    private final ScheduledExecutorService executorService;
    private final Provider<CoordinationProtos.NodeEndpoint> currentEndPoint;
    private final long failSafeLeaderUnavailableDuration;
    private volatile ElectionRegistrationHandle electionHandle;
    private final AtomicBoolean isTaskLeader = new AtomicBoolean(false);
    private ServiceSet serviceSet;
    private volatile RegistrationHandle nodeEndpointRegistrationHandle;
    private Future leadershipReleaseFuture;
    private ConcurrentMap<TaskLeaderChangeListener, TaskLeaderChangeListener> listeners = new ConcurrentHashMap<TaskLeaderChangeListener, TaskLeaderChangeListener>();
    private volatile boolean electionHandleClosed = false;
    private final Function<ElectionListener, ElectionListener> electionListenerProvider;
    private FailSafeReElectionTask failSafeReElectionTask;
    private ScheduledThreadPoolExecutor reElectionExecutor;

    public TaskLeaderElection(String serviceName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider, Provider<ClusterElectionManager> clusterElectionManagerProvider, Provider<CoordinationProtos.NodeEndpoint> currentEndPoint) {
        this(serviceName, clusterServiceSetManagerProvider, clusterElectionManagerProvider, null, currentEndPoint, null);
    }

    public TaskLeaderElection(String serviceName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider, Provider<ClusterElectionManager> clusterElectionManagerProvider, Long leaseExpirationTime, Provider<CoordinationProtos.NodeEndpoint> currentEndPoint, ScheduledExecutorService executorService) {
        this(serviceName, clusterServiceSetManagerProvider, clusterElectionManagerProvider, leaseExpirationTime, currentEndPoint, executorService, 600L, Function.identity());
    }

    public TaskLeaderElection(String serviceName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider, Provider<ClusterElectionManager> clusterElectionManagerProvider, Long leaseExpirationTime, Provider<CoordinationProtos.NodeEndpoint> currentEndPoint, ScheduledExecutorService executorService, Long failSafeLeaderUnavailableDuration, Function<ElectionListener, ElectionListener> electionListenerProvider) {
        this.serviceName = serviceName;
        this.clusterServiceSetManagerProvider = clusterServiceSetManagerProvider;
        this.clusterElectionManagerProvider = clusterElectionManagerProvider;
        this.leaseExpirationTime.set(leaseExpirationTime);
        this.currentEndPoint = currentEndPoint;
        this.taskLeaderStatusListener = new TaskLeaderStatusListener(serviceName, clusterServiceSetManagerProvider);
        this.failSafeLeaderUnavailableDuration = failSafeLeaderUnavailableDuration != null ? failSafeLeaderUnavailableDuration : 600L;
        this.electionListenerProvider = electionListenerProvider;
        if (executorService == null) {
            this.reElectionExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TaskLeaderElection-serviceName").build());
            this.reElectionExecutor.setRemoveOnCancelPolicy(true);
            this.executorService = this.reElectionExecutor;
        } else {
            this.executorService = executorService;
        }
    }

    public void start() throws Exception {
        logger.info("Starting TaskLeaderElection service {}", (Object)this.serviceName);
        this.serviceSet = ((ClusterServiceSetManager)this.clusterServiceSetManagerProvider.get()).getOrCreateServiceSet(this.serviceName);
        this.taskLeaderStatusListener.start();
        this.enterElections();
    }

    public void addListener(TaskLeaderChangeListener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeListener(TaskLeaderChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void updateLeaseExpirationTime(Long newLeaseExpirationTime) {
        this.leaseExpirationTime.updateAndGet(operand -> newLeaseExpirationTime);
    }

    @VisibleForTesting
    public Collection<TaskLeaderChangeListener> getTaskLeaderChangeListeners() {
        return this.listeners.values();
    }

    private void enterElections() {
        logger.info("Starting TaskLeader Election Service for {}", (Object)this.serviceName);
        this.electionHandleClosed = false;
        ElectionListener electionListener = new ElectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onElected() {
                1 electionLock;
                1 var2_2 = electionLock = TaskLeaderElection.this.electionHandle == null ? this : TaskLeaderElection.this.electionHandle.synchronizer();
                synchronized (var2_2) {
                    if (TaskLeaderElection.this.electionHandleClosed) {
                        logger.info("onElected Event: election handle closed for {}. Will not proceed with the on elected function", (Object)TaskLeaderElection.this.serviceName);
                        return;
                    }
                    if (TaskLeaderElection.this.isTaskLeader.compareAndSet(false, true)) {
                        logger.info("onElected Event: Electing Leader for {}", (Object)TaskLeaderElection.this.serviceName);
                        LAST_LEADER_ELECTION.set(System.currentTimeMillis());
                        LEADERSHIP_ELECTION_COUNTER.succeeded();
                        TaskLeaderElection.this.nodeEndpointRegistrationHandle = TaskLeaderElection.this.serviceSet.register((CoordinationProtos.NodeEndpoint)TaskLeaderElection.this.currentEndPoint.get());
                        TaskLeaderElection.this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipGained);
                        if (TaskLeaderElection.this.leaseExpirationTime.get() != null) {
                            logger.info("onElected Event: Restarting leadership lease expiration task {} with {} ms timeout", (Object)TaskLeaderElection.this.serviceName, (Object)TaskLeaderElection.this.leaseExpirationTime.get());
                            TaskLeaderElection.this.leadershipReleaseFuture = TaskLeaderElection.this.executorService.schedule(new LeadershipReset(), (long)TaskLeaderElection.this.leaseExpirationTime.get(), TimeUnit.MILLISECONDS);
                        }
                    } else {
                        logger.debug("onElected Event: This node is already the leader for {}", (Object)TaskLeaderElection.this.serviceName);
                    }
                }
            }

            @Override
            public void onCancelled() {
                if (TaskLeaderElection.this.isTaskLeader.compareAndSet(true, false)) {
                    logger.info("onCancelled Event: Rejecting Leader for {}", (Object)TaskLeaderElection.this.serviceName);
                    if (TaskLeaderElection.this.leadershipReleaseFuture != null) {
                        TaskLeaderElection.this.leadershipReleaseFuture.cancel(false);
                    }
                    TaskLeaderElection.this.nodeEndpointRegistrationHandle.close();
                    TaskLeaderElection.this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipLost);
                } else {
                    logger.debug("onCancelled Event: This node is already NOT the leader for {}", (Object)TaskLeaderElection.this.serviceName);
                }
            }
        };
        this.electionHandle = ((ClusterElectionManager)this.clusterElectionManagerProvider.get()).joinElection(this.serviceName, this.electionListenerProvider.apply(electionListener));
        this.failSafeReElectionTask = new FailSafeReElectionTask();
    }

    public CoordinationProtos.NodeEndpoint getTaskLeader() {
        try {
            this.taskLeaderStatusListener.waitForTaskLeader();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.taskLeaderStatusListener.getTaskLeaderNode();
    }

    public boolean isTaskLeader() {
        return this.isTaskLeader.get();
    }

    @VisibleForTesting
    public void onElectedLeadership() {
        this.isTaskLeader.set(true);
        this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipGained);
    }

    @VisibleForTesting
    public void onCancelledLeadership() {
        this.isTaskLeader.set(false);
        this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipLost);
    }

    @VisibleForTesting
    public void onLeadershipReliquish() {
        this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipRelinquished);
    }

    public Long getLeaseExpirationTime() {
        return this.leaseExpirationTime.get();
    }

    @VisibleForTesting
    public CoordinationProtos.NodeEndpoint getCurrentEndPoint() {
        return (CoordinationProtos.NodeEndpoint)this.currentEndPoint.get();
    }

    @Override
    public void close() throws Exception {
        if (this.isTaskLeader.compareAndSet(true, false)) {
            this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipLost);
        }
        this.listeners.clear();
        if (this.leadershipReleaseFuture != null) {
            this.leadershipReleaseFuture.cancel(true);
        }
        if (this.failSafeReElectionTask != null) {
            this.failSafeReElectionTask.cancel(true);
        }
        if (this.reElectionExecutor != null) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = this.reElectionExecutor::shutdown;
            AutoCloseables.close(autoCloseableArray);
        }
        this.closeHandles();
        AutoCloseables.close(this.taskLeaderStatusListener);
        logger.info("Stopped TaskLeaderElection for service {}", (Object)this.serviceName);
    }

    private synchronized void closeHandles() throws Exception {
        AutoCloseables.close(this.nodeEndpointRegistrationHandle, this.electionHandle);
        this.nodeEndpointRegistrationHandle = null;
        this.electionHandle = null;
    }

    static {
        TimeGauge.builder("task_leader_election.last_elected_time", LAST_LEADER_ELECTION::get, TimeUnit.MILLISECONDS).description("Timestamp of the last successful leader election").register(Metrics.globalRegistry);
        LEADERSHIP_ELECTION_COUNTER = CounterWithOutcome.of("task_leader_election");
    }

    private class FailSafeReElectionTask {
        private long leaderIsNotAvailableFrom = Long.MAX_VALUE;
        private boolean leaderIsNotAvailable = false;
        private final Future failSafeReElectionFuture;

        FailSafeReElectionTask() {
            this.failSafeReElectionFuture = TaskLeaderElection.this.executorService.scheduleAtFixedRate(this::checkAndReElect, 0L, TaskLeaderElection.this.failSafeLeaderUnavailableDuration / 2L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndReElect() {
            if (!this.leaderIsNotAvailable && TaskLeaderElection.this.taskLeaderStatusListener.getTaskLeaderNode() == null) {
                this.leaderIsNotAvailable = true;
                this.leaderIsNotAvailableFrom = System.currentTimeMillis();
            }
            if (this.leaderIsNotAvailable) {
                if (TaskLeaderElection.this.taskLeaderStatusListener.getTaskLeaderNode() != null) {
                    this.leaderIsNotAvailableFrom = Long.MAX_VALUE;
                    this.leaderIsNotAvailable = false;
                } else {
                    long leaderUnavailableDuration = (System.currentTimeMillis() - this.leaderIsNotAvailableFrom) / 1000L;
                    if (leaderUnavailableDuration >= TaskLeaderElection.this.failSafeLeaderUnavailableDuration) {
                        Object object = TaskLeaderElection.this.electionHandle.synchronizer();
                        synchronized (object) {
                            TaskLeaderElection.this.electionHandleClosed = true;
                            LEADERSHIP_ELECTION_COUNTER.errored();
                            if (TaskLeaderElection.this.isTaskLeader.compareAndSet(true, false)) {
                                logger.warn("this is the leader, but looks like leader is not available - closing current election handle and reentering elections for {} as there is no leader for {} secs", (Object)TaskLeaderElection.this.serviceName, (Object)leaderUnavailableDuration);
                                LeadershipReset leadershipReset = new LeadershipReset();
                                leadershipReset.reset();
                                this.cancel(false);
                            } else {
                                logger.warn("this is NOT the leader, and looks like there is no leader available - closing current election handle and reentering elections for {} as there is no leader for {} secs", (Object)TaskLeaderElection.this.serviceName, (Object)leaderUnavailableDuration);
                                try {
                                    AutoCloseables.close(TaskLeaderElection.this.electionHandle);
                                    TaskLeaderElection.this.enterElections();
                                    this.cancel(false);
                                }
                                catch (Exception e) {
                                    logger.error("Failed to end current election handle");
                                }
                            }
                        }
                    }
                }
            }
        }

        void cancel(boolean mayInterruptRunning) {
            if (this.failSafeReElectionFuture != null) {
                this.failSafeReElectionFuture.cancel(mayInterruptRunning);
            }
        }
    }

    private final class LeadershipReset
    implements Runnable {
        private LeadershipReset() {
        }

        @Override
        public void run() {
            if (TaskLeaderElection.this.isTaskLeader.compareAndSet(true, false) && TaskLeaderElection.this.electionHandle.instanceCount() > 1) {
                this.reset();
            } else {
                logger.info("Do not relinquish leadership as it is {} and number of election participants is {}", (Object)(TaskLeaderElection.this.isTaskLeader.get() ? "task leader" : "task follower"), (Object)TaskLeaderElection.this.electionHandle.instanceCount());
            }
        }

        void reset() {
            try {
                logger.info("Trying to relinquish leadership for {}, as number of participants is {}", (Object)TaskLeaderElection.this.serviceName, (Object)TaskLeaderElection.this.electionHandle.instanceCount());
                TaskLeaderElection.this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipRelinquished);
                TaskLeaderElection.this.closeHandles();
                if (TaskLeaderElection.this.leadershipReleaseFuture != null) {
                    TaskLeaderElection.this.leadershipReleaseFuture.cancel(false);
                }
            }
            catch (InterruptedException ie) {
                logger.error("Current thread is interrupted. stopping elections before leader reelections for {}", (Object)TaskLeaderElection.this.serviceName, (Object)ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("Error while trying to close elections before leader reelections for {}", (Object)TaskLeaderElection.this.serviceName);
            }
            TaskLeaderElection.this.enterElections();
        }
    }
}

