/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.local;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.AbstractServiceSet;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterCoordinator;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.DistributedSemaphore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionListener;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionRegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LinearizableHierarchicalStore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.RegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ServiceSet;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.Sets;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class LocalClusterCoordinator
extends ClusterCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(LocalClusterCoordinator.class);
    private final ConcurrentMap<String, DistributedSemaphore> semaphores = new ConcurrentHashMap<String, DistributedSemaphore>();
    private final ConcurrentMap<String, Election> elections = new ConcurrentHashMap<String, Election>();
    private final ConcurrentMap<String, LocalServiceSet> serviceSets = new ConcurrentHashMap<String, LocalServiceSet>();

    @VisibleForTesting
    public static LocalClusterCoordinator newRunningCoordinator() throws Exception {
        LocalClusterCoordinator coordinator = new LocalClusterCoordinator();
        coordinator.start();
        return coordinator;
    }

    public LocalClusterCoordinator() {
        logger.info("Local Cluster Coordinator is up.");
        for (ClusterCoordinator.Role role : ClusterCoordinator.Role.values()) {
            this.serviceSets.put(role.name(), new LocalServiceSet(role.name()));
        }
    }

    @Override
    public void close() throws Exception {
        logger.info("Stopping Local Cluster Coordinator");
        AutoCloseables.close(this.serviceSets.values());
        logger.info("Stopped Local Cluster Coordinator");
    }

    @Override
    public void start() {
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return (ServiceSet)this.serviceSets.get(role.name());
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String name) {
        return this.serviceSets.computeIfAbsent(name, LocalServiceSet::new);
    }

    @Override
    public void deleteServiceSet(String name) {
        LocalServiceSet localServiceSet = (LocalServiceSet)this.serviceSets.remove(name);
        if (localServiceSet != null) {
            try {
                localServiceSet.close();
            }
            catch (Exception e) {
                logger.error("Unable to close LocalServiceSet {}", (Object)name, (Object)e);
            }
        }
    }

    @Override
    public Iterable<String> getServiceNames() {
        return this.serviceSets.keySet();
    }

    @VisibleForTesting
    public LocalServiceSet getServiceSet(String name) {
        return (LocalServiceSet)this.serviceSets.get(name);
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        return this.semaphores.computeIfAbsent(name, key -> new LocalSemaphore(maximumLeases));
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        return this.elections.computeIfAbsent(name, key -> new Election()).joinElection(listener);
    }

    @Override
    public LinearizableHierarchicalStore getHierarchicalStore() {
        throw new UnsupportedOperationException("Hierarchical Store is not supported in Local");
    }

    private static final class LocalServiceSet
    extends AbstractServiceSet
    implements AutoCloseable {
        private final ConcurrentMap<Handle, CoordinationProtos.NodeEndpoint> endpoints = new ConcurrentHashMap<Handle, CoordinationProtos.NodeEndpoint>();
        private final String serviceName;

        public LocalServiceSet(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public RegistrationHandle register(CoordinationProtos.NodeEndpoint endpoint) {
            logger.debug("Endpoint registered {}. {}", (Object)this.serviceName, (Object)endpoint);
            Handle h2 = new Handle();
            this.endpoints.put(h2, endpoint);
            this.nodesRegistered(Sets.newHashSet(endpoint));
            return h2;
        }

        @Override
        public Collection<CoordinationProtos.NodeEndpoint> getAvailableEndpoints() {
            return Collections.unmodifiableCollection(this.endpoints.values());
        }

        public String toString() {
            return this.serviceName;
        }

        @Override
        public void close() throws Exception {
            logger.info("Stopping LocalServiceSet");
            this.clearListeners();
            this.endpoints.clear();
            logger.info("Stopped LocalServiceSet");
        }

        private final class Handle
        implements RegistrationHandle {
            private final UUID id = UUID.randomUUID();

            private Handle() {
            }

            public int hashCode() {
                return Objects.hash(this.getOuterType(), this.id);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Handle other = (Handle)obj;
                return this.getOuterType().equals(other.getOuterType()) && this.id.equals(other.id);
            }

            private LocalServiceSet getOuterType() {
                return LocalServiceSet.this;
            }

            @Override
            public void close() {
                LocalServiceSet.this.endpoints.remove(this);
            }
        }
    }

    private static final class Election {
        private final Queue<Candidate> waiting = new LinkedBlockingQueue<Candidate>();
        private volatile Candidate currentLeader = null;

        private Election() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ElectionRegistrationHandle joinElection(ElectionListener listener) {
            final Candidate candidate = new Candidate(listener);
            Election election = this;
            synchronized (election) {
                if (this.currentLeader == null) {
                    this.currentLeader = candidate;
                    candidate.listener.onElected();
                } else {
                    this.waiting.add(candidate);
                }
            }
            return new ElectionRegistrationHandle(){

                @Override
                public void close() {
                    this.leaveElection(candidate);
                }

                @Override
                public Object synchronizer() {
                    return this;
                }

                @Override
                public int instanceCount() {
                    return waiting.size();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void leaveElection(Candidate candidate) {
            Election election = this;
            synchronized (election) {
                if (this.currentLeader == candidate) {
                    this.currentLeader = this.waiting.poll();
                    if (this.currentLeader != null) {
                        this.currentLeader.listener.onElected();
                    }
                } else {
                    this.waiting.remove(candidate);
                }
            }
        }
    }

    private static final class LocalSemaphore
    implements DistributedSemaphore {
        private final Semaphore semaphore;
        private final int size;
        private final LocalLease singleLease = new LocalLease(1);
        private final Set<DistributedSemaphore.UpdateListener> listeners = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));

        LocalSemaphore(int size) {
            this.semaphore = new Semaphore(size);
            this.size = size;
        }

        @Override
        public boolean hasOutstandingPermits() {
            return this.semaphore.availablePermits() < this.size;
        }

        @Override
        public void forceDeleteParticipantNode(String expectedNodeData) {
        }

        @Override
        public DistributedSemaphore.DistributedLease acquire(long time, TimeUnit unit, byte[] nodeData) throws Exception {
            return this.acquire(1, time, unit);
        }

        @Override
        public DistributedSemaphore.DistributedLease acquire(int numPermits, long timeout, TimeUnit timeUnit) throws Exception {
            Preconditions.checkArgument(numPermits > 0, "numPermits must be a positive integer");
            this.notifyUpdateListeners();
            if (!this.semaphore.tryAcquire(numPermits, timeout, timeUnit)) {
                return null;
            }
            return numPermits == 1 ? this.singleLease : new LocalLease(numPermits);
        }

        @Override
        public boolean registerUpdateListener(DistributedSemaphore.UpdateListener listener) {
            return this.listeners.add(listener);
        }

        private void notifyUpdateListeners() {
            ArrayList<DistributedSemaphore.UpdateListener> copy = new ArrayList<DistributedSemaphore.UpdateListener>(this.listeners);
            for (DistributedSemaphore.UpdateListener listener : copy) {
                try {
                    listener.updated();
                }
                catch (Exception e) {
                    logger.warn("Exception occurred while notifying listener: " + String.valueOf(listener), e);
                }
            }
        }

        private class LocalLease
        implements DistributedSemaphore.DistributedLease {
            private final int numPermits;

            LocalLease(int numPermits) {
                this.numPermits = numPermits;
            }

            @Override
            public void close() throws Exception {
                LocalSemaphore.this.semaphore.release(this.numPermits);
                LocalSemaphore.this.notifyUpdateListeners();
            }
        }
    }

    private static final class Candidate {
        private final ElectionListener listener;

        public Candidate(ElectionListener listener) {
            this.listener = listener;
        }
    }
}

