/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk;

import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.curator.RetryPolicy;
import com.dremio.jdbc.shaded.org.apache.curator.RetrySleeper;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class BoundedExponentialDelay
implements RetryPolicy {
    private final int baseSleepTimeMs;
    private final int maxSleepMs;
    private final long maxRetry;

    public BoundedExponentialDelay(int baseSleepTimeMs, int maxSleepMs, boolean unlimited, long maxRetry) {
        Preconditions.checkArgument(baseSleepTimeMs > 0, "baseSleepTimeMs must be positive");
        Preconditions.checkArgument(maxSleepMs > baseSleepTimeMs, "maxSleepMs > baseSleepTimeMs");
        Preconditions.checkArgument(unlimited || maxRetry > 0L, "maxRetry must be positive");
        this.baseSleepTimeMs = baseSleepTimeMs;
        this.maxSleepMs = maxSleepMs;
        this.maxRetry = unlimited ? -1L : maxRetry;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        if (this.maxRetry != -1L && this.maxRetry < (long)retryCount) {
            return false;
        }
        try {
            sleeper.sleepFor(this.getSleepTimeMs(retryCount), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private int getSleepTimeMs(int retryCount) {
        int exponent = Math.min(29, retryCount) + 1;
        int multiplier = Math.max(1, ThreadLocalRandom.current().nextInt(1 << exponent));
        return Math.min(this.maxSleepMs, this.baseSleepTimeMs * multiplier);
    }
}

