/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterCoordinator;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.DistributedSemaphore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionListener;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionRegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LinearizableHierarchicalStore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ServiceSet;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterClient;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterConfig;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterServiceSetManager;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKSabotConfig;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import javax.inject.Provider;

public class ZKClusterCoordinator
extends ClusterCoordinator {
    static final Logger logger = LoggerFactory.getLogger(ZKClusterCoordinator.class);
    private final ZKClusterServiceSetManager zkClusterServiceSetManager;
    private final int sessionTimeoutMillis;
    private volatile boolean closed = false;

    public ZKClusterCoordinator(SabotConfig config) throws IOException {
        this(config, (String)null);
    }

    public ZKClusterCoordinator(SabotConfig config, String connect) throws IOException {
        this((ZKClusterConfig)new ZKSabotConfig(config), connect);
    }

    public ZKClusterCoordinator(SabotConfig config, Provider<Integer> localPort) throws IOException {
        ZKSabotConfig sabotConfig = new ZKSabotConfig(config);
        this.zkClusterServiceSetManager = new ZKClusterServiceSetManager((ZKClusterConfig)sabotConfig, localPort);
        this.sessionTimeoutMillis = sabotConfig.getSessionTimeoutMilliSecs();
    }

    public ZKClusterCoordinator(ZKClusterConfig zkClusterConfig, Provider<Integer> localPort) throws IOException {
        this.zkClusterServiceSetManager = new ZKClusterServiceSetManager(zkClusterConfig, localPort);
        this.sessionTimeoutMillis = zkClusterConfig.getSessionTimeoutMilliSecs();
    }

    public ZKClusterCoordinator(ZKClusterConfig zkClusterConfig, String connect) throws IOException {
        this.zkClusterServiceSetManager = new ZKClusterServiceSetManager(zkClusterConfig, connect);
        this.sessionTimeoutMillis = zkClusterConfig.getSessionTimeoutMilliSecs();
    }

    @VisibleForTesting
    ZKClusterClient getZkClient() {
        return this.zkClusterServiceSetManager.getZkClient();
    }

    @VisibleForTesting
    public void setPortProvider(Provider<Integer> portProvider) {
        this.zkClusterServiceSetManager.getZkClient().setPortProvider(portProvider);
    }

    @Override
    public void start() throws Exception {
        this.zkClusterServiceSetManager.start();
        if (!this.closed) {
            Thread.sleep(5L);
            for (Service service : Service.values()) {
                this.zkClusterServiceSetManager.getOrCreateServiceSet(service.role.name(), service.name);
            }
            logger.info("ZKClusterCoordination is up");
        }
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return this.zkClusterServiceSetManager.getServiceSet(role);
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String serviceName) {
        return this.zkClusterServiceSetManager.getOrCreateServiceSet(serviceName);
    }

    @Override
    public void deleteServiceSet(String serviceName) {
        this.zkClusterServiceSetManager.deleteServiceSet(serviceName);
    }

    @Override
    public Iterable<String> getServiceNames() throws Exception {
        return this.zkClusterServiceSetManager.getServiceNames();
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        return this.zkClusterServiceSetManager.getZkClient().getSemaphore(name, maximumLeases);
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        return this.zkClusterServiceSetManager.joinElection(name, listener);
    }

    @Override
    public LinearizableHierarchicalStore getHierarchicalStore() {
        return this.zkClusterServiceSetManager.getZkClient().getHierarchicalStore();
    }

    @Override
    public int getSessionTimeoutMillis() {
        return this.sessionTimeoutMillis;
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            AutoCloseables.close(this.zkClusterServiceSetManager);
        }
    }

    private static enum Service {
        COORDINATOR(ClusterCoordinator.Role.COORDINATOR, "coordinator"),
        EXECUTOR(ClusterCoordinator.Role.EXECUTOR, "executor"),
        MASTER(ClusterCoordinator.Role.MASTER, "master");

        private final ClusterCoordinator.Role role;
        private final String name;

        private Service(ClusterCoordinator.Role role, String serviceName) {
            this.role = role;
            this.name = serviceName;
        }
    }
}

