/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterCoordinator;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterElectionManager;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterServiceSetManager;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionListener;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionRegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ServiceSet;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterClient;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterConfig;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKServiceSet;
import com.dremio.jdbc.shaded.com.google.common.collect.Maps;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;

public class ZKClusterServiceSetManager
implements ClusterServiceSetManager,
ClusterElectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ZKClusterServiceSetManager.class);
    private final ConcurrentMap<String, ZKServiceSet> serviceSets = Maps.newConcurrentMap();
    private final ZKClusterClient zkClient;

    public ZKClusterServiceSetManager(ZKClusterConfig config) throws IOException {
        this(config, (String)null);
    }

    public ZKClusterServiceSetManager(ZKClusterConfig config, String connect) throws IOException {
        this(new ZKClusterClient(config, connect));
    }

    public ZKClusterServiceSetManager(ZKClusterConfig config, Provider<Integer> localPort) throws IOException {
        this(new ZKClusterClient(config, localPort));
    }

    public ZKClusterServiceSetManager(ZKClusterClient clusterClient) {
        this.zkClient = clusterClient;
    }

    @Override
    public void start() throws Exception {
        this.zkClient.start();
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return (ServiceSet)this.serviceSets.get(role.name());
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String serviceName) {
        return this.serviceSets.computeIfAbsent(serviceName, s2 -> {
            ZKServiceSet newServiceSet = this.zkClient.newServiceSet(serviceName);
            try {
                newServiceSet.start();
                logger.info("Started zkServiceSet for service {}", (Object)serviceName);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to start %s service in Zookeeper", serviceName), e);
            }
            return newServiceSet;
        });
    }

    @Override
    public void deleteServiceSet(String serviceName) {
        ZKServiceSet serviceSet = (ZKServiceSet)this.serviceSets.remove(serviceName);
        if (serviceSet != null) {
            try {
                serviceSet.close();
                this.zkClient.deleteServiceSetZkNode(serviceName);
                logger.info("Stopped zkServiceSet for service {}", (Object)serviceName);
            }
            catch (Exception e) {
                logger.error("Unable to close zkService for service {}", (Object)serviceName, (Object)e);
            }
        }
    }

    public ServiceSet getOrCreateServiceSet(String role, String serviceName) {
        return this.serviceSets.computeIfAbsent(role, s2 -> {
            ZKServiceSet newServiceSet = this.zkClient.newServiceSet(serviceName);
            try {
                newServiceSet.start();
                logger.info("Started zkServiceSet for service {} and role {}", (Object)serviceName, (Object)role);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to start %s service in Zookeeper", serviceName), e);
            }
            return newServiceSet;
        });
    }

    @Override
    public Iterable<String> getServiceNames() throws Exception {
        return this.zkClient.getServiceNames();
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        return this.zkClient.joinElection(name, listener);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.serviceSets.values(), AutoCloseables.iter(this.zkClient));
    }

    public ZKClusterClient getZkClient() {
        return this.zkClient;
    }
}

