/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk;

import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LinearizableHierarchicalStore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LostConnectionObserver;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.exceptions.PathExistsException;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.exceptions.PathMissingException;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.exceptions.StoreFatalException;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.ACLPathAndBytesable;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.BackgroundPathable;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.ChildrenDeletable;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.CuratorWatcher;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.transaction.CuratorOp;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import com.dremio.jdbc.shaded.org.apache.zookeeper.CreateMode;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.WatchedEvent;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Watcher;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.Stat;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ZKLinearizableStore
implements LinearizableHierarchicalStore,
LostConnectionObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKLinearizableStore.class);
    private static final Map<LinearizableHierarchicalStore.CommandType, Function<ZKLinearizableStore, Op>> OP_LAB;
    private static final NoOp NO_OP_OBJ;
    private static final Function<ZKLinearizableStore, Op> NO_OP;
    private final CuratorFramework zkClient;
    private final Map<ZKStoreOpWatcher, CompletableFuture<Void>> watcherMap;
    private final List<LostConnectionObserver> lostConnectionObservers;
    private final String rootLatchPath;

    ZKLinearizableStore(CuratorFramework zkClient, String rootLatchPath) {
        this.zkClient = zkClient;
        this.watcherMap = new ConcurrentHashMap<ZKStoreOpWatcher, CompletableFuture<Void>>();
        this.lostConnectionObservers = new CopyOnWriteArrayList<LostConnectionObserver>();
        this.rootLatchPath = rootLatchPath;
    }

    @Override
    public boolean electionPathExists(String name) {
        String latchPath = this.rootLatchPath + name;
        boolean leaderElectionOn = false;
        try {
            if (this.zkClient.checkExists().forPath(latchPath) != null) {
                List allChildren = (List)this.zkClient.getChildren().forPath(latchPath);
                leaderElectionOn = !allChildren.isEmpty();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return leaderElectionOn;
    }

    @Override
    public void executeMulti(LinearizableHierarchicalStore.PathCommand[] commands) throws PathMissingException, PathExistsException {
        Preconditions.checkArgument(commands.length >= 2, "Unexpected number of store commands");
        ArrayList<CuratorOp> curatorOps = new ArrayList<CuratorOp>();
        try {
            for (LinearizableHierarchicalStore.PathCommand command : commands) {
                Op op = OP_LAB.getOrDefault((Object)command.getCommandType(), NO_OP).apply(this);
                curatorOps.add(op.createOp(command));
            }
            List<CuratorTransactionResult> results = this.zkClient.transaction().forOperations(curatorOps);
            this.checkResults(results);
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                throw new PathExistsException(((KeeperException.NodeExistsException)e).getPath());
            }
            if (e instanceof KeeperException.NoNodeException) {
                throw new PathMissingException(((KeeperException.NoNodeException)e).getPath());
            }
            throw new StoreFatalException(e);
        }
    }

    @Override
    public void executeSingle(LinearizableHierarchicalStore.PathCommand command) throws PathMissingException, PathExistsException {
        Op op = OP_LAB.getOrDefault((Object)command.getCommandType(), NO_OP).apply(this);
        try {
            op.doOp(command);
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                throw new PathExistsException(((KeeperException.NodeExistsException)e).getPath());
            }
            if (e instanceof KeeperException.NoNodeException) {
                throw new PathMissingException(((KeeperException.NoNodeException)e).getPath());
            }
            throw new StoreFatalException(e);
        }
    }

    @Override
    public byte[] getData(String fullPath) throws PathMissingException {
        try {
            byte[] data = (byte[])this.zkClient.getData().forPath(fullPath);
            return data == null || data.length == 0 ? null : data;
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                throw new PathMissingException(fullPath);
            }
            throw new StoreFatalException(e);
        }
    }

    @Override
    public byte[] getData(String fullPath, CompletableFuture<Void> onDataChanged) throws PathMissingException {
        try {
            byte[] data;
            ZKStoreOpWatcher watcher = new ZKStoreOpWatcher(fullPath, onDataChanged, Watcher.Event.EventType.NodeDataChanged);
            if (onDataChanged == null || this.watcherMap.containsKey(watcher)) {
                data = (byte[])this.zkClient.getData().forPath(fullPath);
            } else {
                this.watcherMap.put(watcher, onDataChanged);
                data = (byte[])((BackgroundPathable)this.zkClient.getData().usingWatcher(watcher)).forPath(fullPath);
            }
            return data;
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                throw new PathMissingException(fullPath);
            }
            throw new StoreFatalException(e);
        }
    }

    @Override
    public boolean checkExists(String fullPath) {
        try {
            return this.zkClient.checkExists().forPath(fullPath) != null;
        }
        catch (Exception e) {
            throw new StoreFatalException(e);
        }
    }

    @Override
    public LinearizableHierarchicalStore.Stats getStats(String fullPath) {
        try {
            final Stat s2 = (Stat)this.zkClient.checkExists().forPath(fullPath);
            return s2 == null ? null : new LinearizableHierarchicalStore.Stats(){

                @Override
                public long getCreationTime() {
                    return s2.getCtime();
                }

                @Override
                public long getLastModifiedTime() {
                    return s2.getMtime();
                }

                @Override
                public int getNumChanges() {
                    return s2.getVersion();
                }

                @Override
                public long getSessionId() {
                    return s2.getEphemeralOwner();
                }
            };
        }
        catch (Exception e) {
            throw new StoreFatalException(e);
        }
    }

    @Override
    public CompletableFuture<Void> whenDeleted(String fullPath) throws PathMissingException {
        assert (fullPath != null);
        CompletableFuture<Void> onPathDeletion = new CompletableFuture<Void>();
        ZKStoreOpWatcher watcher = new ZKStoreOpWatcher(fullPath, onPathDeletion, Watcher.Event.EventType.NodeDeleted);
        CompletableFuture actual = this.watcherMap.compute(watcher, (k, v) -> {
            if (v == null) {
                try {
                    boolean exists = ((BackgroundPathable)this.zkClient.checkExists().usingWatcher(watcher)).forPath(fullPath) != null;
                    return exists ? onPathDeletion : null;
                }
                catch (Exception e) {
                    throw new StoreFatalException(e);
                }
            }
            return v;
        });
        if (actual == null) {
            throw new PathMissingException(fullPath);
        }
        return actual;
    }

    @Override
    public CompletableFuture<Void> whenCreated(String fullPath) throws PathExistsException {
        assert (fullPath != null);
        CompletableFuture<Void> onPathCreation = new CompletableFuture<Void>();
        ZKStoreOpWatcher watcher = new ZKStoreOpWatcher(fullPath, onPathCreation, Watcher.Event.EventType.NodeCreated);
        CompletableFuture actual = this.watcherMap.compute(watcher, (k, v) -> {
            if (v == null) {
                try {
                    boolean exists = ((BackgroundPathable)this.zkClient.checkExists().usingWatcher(watcher)).forPath(fullPath) != null;
                    return exists ? null : onPathCreation;
                }
                catch (Exception e) {
                    throw new StoreFatalException(e);
                }
            }
            return v;
        });
        if (actual == null) {
            throw new PathExistsException(fullPath);
        }
        return actual;
    }

    @Override
    public List<String> getChildren(String fullPath, CompletableFuture<Void> onChildrenChanged) throws PathMissingException {
        assert (fullPath != null);
        try {
            List origChildren;
            ZKStoreOpWatcher watcher = new ZKStoreOpWatcher(fullPath, onChildrenChanged, Watcher.Event.EventType.NodeChildrenChanged);
            if (onChildrenChanged == null || this.watcherMap.containsKey(watcher)) {
                origChildren = (List)this.zkClient.getChildren().forPath(fullPath);
            } else {
                this.watcherMap.put(watcher, onChildrenChanged);
                origChildren = (List)((BackgroundPathable)this.zkClient.getChildren().usingWatcher(watcher)).forPath(fullPath);
                watcher.setLastSeen(origChildren);
            }
            return origChildren;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerLostConnectionObserver(LostConnectionObserver observer) {
        LOGGER.info("Setting external connection lost observer");
        this.lostConnectionObservers.add(observer);
    }

    private void checkResults(List<CuratorTransactionResult> results) {
        for (CuratorTransactionResult result : results) {
            Preconditions.checkArgument(result.getError() == KeeperException.Code.OK.intValue(), "Unexpected failure result on Path " + result.getForPath());
        }
    }

    @Override
    public void notifyLostConnection() {
        LOGGER.info("Notifying connection lost to all external registered observers");
        this.watcherMap.clear();
        this.lostConnectionObservers.forEach(LostConnectionObserver::notifyLostConnection);
    }

    @Override
    public void notifyConnectionRegainedAfterLost() {
        LOGGER.info("Notifying Reconnection to all external registered observers");
        this.lostConnectionObservers.forEach(LostConnectionObserver::notifyConnectionRegainedAfterLost);
    }

    static {
        NO_OP_OBJ = new NoOp();
        NO_OP = z -> NO_OP_OBJ;
        HashMap<LinearizableHierarchicalStore.CommandType, Function<ZKLinearizableStore, Op>> tmpMap = new HashMap<LinearizableHierarchicalStore.CommandType, Function<ZKLinearizableStore, Op>>();
        tmpMap.put(LinearizableHierarchicalStore.CommandType.CREATE_EPHEMERAL, z -> (ZKLinearizableStore)z.new CreateEphemeralOp());
        tmpMap.put(LinearizableHierarchicalStore.CommandType.CREATE_EPHEMERAL_SEQUENTIAL, z -> (ZKLinearizableStore)z.new CreateEphemeralSequentialOp());
        tmpMap.put(LinearizableHierarchicalStore.CommandType.CREATE_PERSISTENT, z -> (ZKLinearizableStore)z.new CreatePersistentOp());
        tmpMap.put(LinearizableHierarchicalStore.CommandType.DELETE, z -> (ZKLinearizableStore)z.new DeleteOp());
        tmpMap.put(LinearizableHierarchicalStore.CommandType.SET_DATA, z -> (ZKLinearizableStore)z.new SetDataOp());
        OP_LAB = Collections.unmodifiableMap(tmpMap);
    }

    private static interface Op {
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand var1) throws Exception;

        public void doOp(LinearizableHierarchicalStore.PathCommand var1) throws Exception;
    }

    private final class ZKStoreOpWatcher
    implements CuratorWatcher {
        private final String fullPath;
        private final CompletableFuture<Void> onOpComplete;
        private final Watcher.Event.EventType expectedEventType;
        private final AtomicReference<List<String>> lastSeenChildren;

        private ZKStoreOpWatcher(String fullPath, CompletableFuture<Void> onOpComplete, Watcher.Event.EventType eventType) {
            this.fullPath = fullPath;
            this.onOpComplete = onOpComplete;
            this.expectedEventType = eventType;
            this.lastSeenChildren = new AtomicReference<Object>(null);
        }

        @Override
        public void process(WatchedEvent watchedEvent) {
            LOGGER.debug("Watcher Event {} triggered for path {}", (Object)watchedEvent.getType(), (Object)this.fullPath);
            if (watchedEvent.getType().equals((Object)this.expectedEventType)) {
                ZKLinearizableStore.this.watcherMap.remove(this);
                this.onOpComplete.complete(null);
            } else if (Watcher.Event.EventType.None.equals((Object)watchedEvent.getType()) && Watcher.Event.KeeperState.SyncConnected.equals((Object)watchedEvent.getState())) {
                LOGGER.info("Reconnect Event Received for watcher of type {} on path {}", (Object)this.expectedEventType, (Object)this.fullPath);
                this.recover();
            } else {
                LOGGER.debug("Unknown watcher event {} received for path {}", (Object)watchedEvent.getType(), (Object)this.fullPath);
            }
        }

        public void setLastSeen(List<String> origChildren) {
            this.lastSeenChildren.set(origChildren);
        }

        private void recover() {
            switch (this.expectedEventType) {
                case NodeDeleted: {
                    try {
                        boolean exists;
                        boolean bl = exists = ((BackgroundPathable)ZKLinearizableStore.this.zkClient.checkExists().usingWatcher(this)).forPath(this.fullPath) != null;
                        if (exists) break;
                        ZKLinearizableStore.this.watcherMap.remove(this);
                        if (this.onOpComplete.isDone()) break;
                        this.onOpComplete.complete(null);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Internal Error: Unexpected exception while recovering deletion watcher for {}", (Object)this.fullPath, (Object)e);
                    }
                    break;
                }
                case NodeCreated: {
                    try {
                        boolean exists;
                        boolean bl = exists = ((BackgroundPathable)ZKLinearizableStore.this.zkClient.checkExists().usingWatcher(this)).forPath(this.fullPath) != null;
                        if (!exists) break;
                        ZKLinearizableStore.this.watcherMap.remove(this);
                        if (this.onOpComplete.isDone()) break;
                        this.onOpComplete.complete(null);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Internal Error: Unexpected exception while recovering creation watcher for {}", (Object)this.fullPath, (Object)e);
                    }
                    break;
                }
                case NodeChildrenChanged: {
                    try {
                        List currentSeen = (List)((BackgroundPathable)ZKLinearizableStore.this.zkClient.getChildren().usingWatcher(this)).forPath(this.fullPath);
                        if (currentSeen.equals(this.lastSeenChildren.get())) break;
                        ZKLinearizableStore.this.watcherMap.remove(this);
                        if (this.onOpComplete.isDone()) break;
                        this.onOpComplete.complete(null);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Internal Error: Unexpected exception while recovering watcher", e);
                    }
                    break;
                }
                case NodeDataChanged: {
                    ZKLinearizableStore.this.watcherMap.remove(this);
                    if (this.onOpComplete.isDone()) break;
                    this.onOpComplete.complete(null);
                    break;
                }
                default: {
                    LOGGER.debug("Unknown event type {}", (Object)this.expectedEventType);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZKStoreOpWatcher that = (ZKStoreOpWatcher)o;
            return this.fullPath.equals(that.fullPath) && this.expectedEventType == that.expectedEventType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.fullPath, this.expectedEventType});
        }
    }

    private final class SetDataOp
    implements Op {
        private SetDataOp() {
        }

        @Override
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            Preconditions.checkArgument(cmd.getData() != null, "Valid data must be presented to store");
            return (CuratorOp)ZKLinearizableStore.this.zkClient.transactionOp().setData().forPath(cmd.getFullPath(), cmd.getData());
        }

        @Override
        public void doOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            Preconditions.checkArgument(cmd.getData() != null, "Valid data must be presented to store");
            ZKLinearizableStore.this.zkClient.setData().forPath(cmd.getFullPath(), cmd.getData());
        }
    }

    private final class DeleteOp
    implements Op {
        private DeleteOp() {
        }

        @Override
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            return (CuratorOp)ZKLinearizableStore.this.zkClient.transactionOp().delete().forPath(cmd.getFullPath());
        }

        @Override
        public void doOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            ((ChildrenDeletable)ZKLinearizableStore.this.zkClient.delete().guaranteed()).forPath(cmd.getFullPath());
        }
    }

    private final class CreatePersistentOp
    implements Op {
        private CreatePersistentOp() {
        }

        @Override
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            byte[] dataToSend = cmd.getData() == null || cmd.getData().length == 0 ? null : cmd.getData();
            return (CuratorOp)((ACLPathAndBytesable)ZKLinearizableStore.this.zkClient.transactionOp().create().withMode(CreateMode.PERSISTENT)).forPath(cmd.getFullPath(), dataToSend);
        }

        @Override
        public void doOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            byte[] dataToSend = cmd.getData() == null || cmd.getData().length == 0 ? null : cmd.getData();
            String ret = (String)((ACLBackgroundPathAndBytesable)ZKLinearizableStore.this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(cmd.getFullPath(), dataToSend);
            cmd.setReturnValue(ret);
        }
    }

    private final class CreateEphemeralSequentialOp
    implements Op {
        private CreateEphemeralSequentialOp() {
        }

        @Override
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            byte[] dataToSend = cmd.getData() == null || cmd.getData().length == 0 ? null : cmd.getData();
            return (CuratorOp)((ACLPathAndBytesable)ZKLinearizableStore.this.zkClient.transactionOp().create().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(cmd.getFullPath(), dataToSend);
        }

        @Override
        public void doOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            byte[] dataToSend = cmd.getData() == null || cmd.getData().length == 0 ? null : cmd.getData();
            String ret = (String)((ACLBackgroundPathAndBytesable)ZKLinearizableStore.this.zkClient.create().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(cmd.getFullPath(), dataToSend);
            cmd.setReturnValue(ret);
        }
    }

    private final class CreateEphemeralOp
    implements Op {
        private CreateEphemeralOp() {
        }

        @Override
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            byte[] dataToSend = cmd.getData() == null || cmd.getData().length == 0 ? null : cmd.getData();
            return (CuratorOp)((ACLPathAndBytesable)ZKLinearizableStore.this.zkClient.transactionOp().create().withMode(CreateMode.EPHEMERAL)).forPath(cmd.getFullPath(), dataToSend);
        }

        @Override
        public void doOp(LinearizableHierarchicalStore.PathCommand cmd) throws Exception {
            byte[] dataToSend = cmd.getData() == null || cmd.getData().length == 0 ? null : cmd.getData();
            String ret = (String)((ACLBackgroundPathAndBytesable)ZKLinearizableStore.this.zkClient.create().withMode(CreateMode.EPHEMERAL)).forPath(cmd.getFullPath(), dataToSend);
            cmd.setReturnValue(ret);
        }
    }

    private static final class NoOp
    implements Op {
        private NoOp() {
        }

        @Override
        public CuratorOp createOp(LinearizableHierarchicalStore.PathCommand cmd) {
            throw new IllegalArgumentException("Unimplemented hierarchical store operation type " + String.valueOf((Object)cmd.getCommandType()));
        }

        @Override
        public void doOp(LinearizableHierarchicalStore.PathCommand cmd) {
            throw new IllegalArgumentException("Unimplemented hierarchical store operation type " + String.valueOf((Object)cmd.getCommandType()));
        }
    }
}

