/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk;

import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.options.TypeValidators;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.CoordinatorLostHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ObservableConnectionLostHandler;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterConfig;
import java.util.function.Predicate;

public class ZKSabotConfig
implements ZKClusterConfig {
    private final SabotConfig config;

    public ZKSabotConfig(SabotConfig sabotConfig) {
        this.config = sabotConfig;
    }

    @Override
    public int getConnectionTimeoutMilliSecs() {
        return this.config.getInt("dremio.exec.zk.timeout");
    }

    @Override
    public int getSessionTimeoutMilliSecs() {
        return this.config.getInt("dremio.exec.zk.session.timeout");
    }

    @Override
    public String getRoot() {
        return this.config.getString("dremio.exec.zk.root");
    }

    @Override
    public int getRetryBaseDelayMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.retry.delay.base").intValue();
    }

    @Override
    public long getInitialTimeoutMilliSecs() {
        return this.config.getLong("dremio.exec.zk.retry.initial_timeout_ms");
    }

    @Override
    public int getRetryMaxDelayMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.retry.delay.max").intValue();
    }

    @Override
    public boolean isRetryUnlimited() {
        return this.config.getBoolean("dremio.exec.zk.retry.unlimited");
    }

    @Override
    public boolean isConnectionHandleEnabled() {
        return this.config.getBoolean("dremio.exec.zk.connection_handle.enabled");
    }

    @Override
    public long getRetryLimit() {
        return this.config.getLong("dremio.exec.zk.retry.limit");
    }

    @Override
    public long getElectionTimeoutMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.election.timeout");
    }

    @Override
    public long getElectionPollingMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.election.polling");
    }

    @Override
    public long getElectionDelayForLeaderCallbackMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.election.delay_for_leader_callback");
    }

    @Override
    public CoordinatorLostHandle getConnectionLostHandler() {
        return this.config.getInstance("dremio.coordinator_lost_handle.module.class", CoordinatorLostHandle.class, ObservableConnectionLostHandler.OBSERVABLE_LOST_HANDLER.get(), new Object[0]);
    }

    @Override
    public String getClusterId() {
        return this.config.getString("dremio.exec.cluster-id");
    }

    @Override
    public String getConnection() {
        return this.config.getString("dremio.exec.zk.connect");
    }

    @Override
    public Predicate<TypeValidators.BooleanValidator> getFeatureEvaluator() {
        return null;
    }

    @Override
    public int getZkSupervisorIntervalMilliSec() {
        return this.config.getInt("dremio.exec.zk.supervisor.interval_ms");
    }

    @Override
    public int getZkSupervisorReadTimeoutMilliSec() {
        return this.config.getInt("dremio.exec.zk.supervisor.read_timeout_ms");
    }

    @Override
    public int getZkSupervisorMaxFailures() {
        return this.config.getInt("dremio.exec.zk.supervisor.max_failures");
    }
}

