/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.DistributedSemaphore;
import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.BackgroundPathable;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.ChildrenDeletable;
import com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.locks.Lease;
import com.dremio.jdbc.shaded.org.apache.curator.utils.ZKPaths;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.WatchedEvent;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Watcher;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

class ZkDistributedSemaphore
implements DistributedSemaphore {
    private static final Logger logger = LoggerFactory.getLogger(ZkDistributedSemaphore.class);
    private static final int WATCHER_CHECK_GAP_MILLIS = 60000;
    private final InterProcessSemaphoreV2 semaphore;
    private final Map<DistributedSemaphore.UpdateListener, Void> listeners = Collections.synchronizedMap(new WeakHashMap());
    private final String path;
    private final CuratorFramework client;
    private final AtomicBoolean childWatchEnabled;
    private volatile long lastWatcherCheckedAtMillis;

    ZkDistributedSemaphore(CuratorFramework client, String path, int numberOfLeases) throws Exception {
        this.semaphore = new InterProcessSemaphoreV2(client, path, numberOfLeases);
        this.path = ZKPaths.makePath(path, "leases");
        this.client = client;
        this.childWatchEnabled = new AtomicBoolean(false);
        this.lastWatcherCheckedAtMillis = 0L;
    }

    private boolean setWatcher() throws Exception {
        if (this.client.checkExists().forPath(this.path) != null) {
            if (this.childWatchEnabled.compareAndSet(false, true)) {
                ((BackgroundPathable)this.client.getChildren().usingWatcher(this::onEvent)).forPath(this.path);
                logger.debug("watcher set for path: {}", (Object)this.path);
            } else {
                logger.debug("watcher already set for path: {}", (Object)this.path);
            }
            return true;
        }
        logger.debug("path {} not found", (Object)this.path);
        return false;
    }

    private void onEvent(WatchedEvent event) {
        this.childWatchEnabled.set(false);
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            ArrayList<DistributedSemaphore.UpdateListener> col = new ArrayList<DistributedSemaphore.UpdateListener>(this.listeners.keySet());
            for (DistributedSemaphore.UpdateListener l : col) {
                l.updated();
            }
        }
    }

    @Override
    public boolean hasOutstandingPermits() {
        try {
            return !this.semaphore.getParticipantNodes().isEmpty();
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                logger.debug("No node exception.", e);
                return false;
            }
            logger.warn("exception when semaphore trying to get participant nodes.", e);
            return true;
        }
    }

    @Override
    public void forceDeleteParticipantNode(String expectedNodeData) {
        try {
            for (String participantNode : this.semaphore.getParticipantNodes()) {
                String leasePath = ZKPaths.makePath(this.path, participantNode);
                try {
                    byte[] nodeBytes = (byte[])this.client.getData().forPath(leasePath);
                    if (nodeBytes == null || !new String(nodeBytes).equals(expectedNodeData)) continue;
                    logger.warn("Forcefully deleting a leaked permit for path {} that contains {}", (Object)leasePath, (Object)expectedNodeData);
                    ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(leasePath);
                }
                catch (Exception e) {
                    if (e instanceof KeeperException.NoNodeException) {
                        logger.debug("Lease path {} no longer exists", (Object)leasePath, (Object)e);
                        continue;
                    }
                    logger.warn("Unable to read or delete lease path {}", (Object)leasePath, (Object)e);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                logger.debug("Semaphore path no longer exists for {}", (Object)expectedNodeData, (Object)e);
            }
            logger.warn("Exception occurred while trying to get semaphore participant node for {}.", (Object)expectedNodeData, (Object)e);
        }
    }

    @Override
    public DistributedSemaphore.DistributedLease acquire(long time, TimeUnit unit, byte[] nodeData) throws Exception {
        if (nodeData != null) {
            this.semaphore.setNodeData(nodeData);
        }
        return this.acquire(1, time, unit);
    }

    @Override
    public DistributedSemaphore.DistributedLease acquire(int numPermits, long time, TimeUnit unit) throws Exception {
        Collection<Lease> leases = this.semaphore.acquire(numPermits, time, unit);
        if (leases != null) {
            return new LeasesHolder(leases);
        }
        return null;
    }

    @Override
    public boolean registerUpdateListener(DistributedSemaphore.UpdateListener listener) {
        boolean set = true;
        try {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis > this.lastWatcherCheckedAtMillis + 60000L) {
                set = this.setWatcher();
                this.lastWatcherCheckedAtMillis = currentTimeMillis;
            }
        }
        catch (Exception e) {
            logger.warn("Exception occurred while registering listener", e);
        }
        this.listeners.put(() -> {
            try {
                listener.updated();
            }
            catch (Exception e) {
                logger.warn("Exception occurred while notifying listener.", e);
            }
        }, null);
        return set;
    }

    private class LeasesHolder
    implements DistributedSemaphore.DistributedLease {
        private Collection<Lease> leases;

        LeasesHolder(Collection<Lease> leases) {
            this.leases = leases;
        }

        @Override
        public void close() throws Exception {
            AutoCloseables.close(this.leases);
        }

        @Override
        public String formatAsString() {
            return this.leases.stream().map(Lease::getNodeName).map(it -> ZKPaths.makePath(ZkDistributedSemaphore.this.path, it)).collect(Collectors.joining(",", "[", "]"));
        }
    }
}

