/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.ssl;

import com.dremio.jdbc.shaded.com.dremio.ssl.CompositeTrustManager;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableList;
import com.dremio.jdbc.shaded.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public final class CompositeTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(CompositeTrustManagerFactory.class);
    private final CompositeTrustManager trustManager;

    private CompositeTrustManagerFactory(Builder builder) {
        this.trustManager = new CompositeTrustManager((ImmutableList<X509ExtendedTrustManager>)builder.trustManagersBuilder.build());
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.trustManager};
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<X509ExtendedTrustManager> trustManagersBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder addDefaultTrustStore() {
            return this.addTrustStore((KeyStore)null);
        }

        public Builder addTrustStore(KeyStore keyStore) {
            try {
                Builder.toX509TrustManager(keyStore).ifPresent(this.trustManagersBuilder::add);
            }
            catch (KeyStoreException ex) {
                logger.warn("Unable to load KeyStore of type {}", (Object)keyStore, (Object)ex);
            }
            return this;
        }

        @VisibleForTesting
        Builder addTrustStore(Iterable<X509ExtendedTrustManager> managers) {
            this.trustManagersBuilder.addAll((Iterable)managers);
            return this;
        }

        public CompositeTrustManagerFactory build() {
            return new CompositeTrustManagerFactory(this);
        }

        private static Optional<X509ExtendedTrustManager> toX509TrustManager(KeyStore keyStore) throws KeyStoreException {
            try {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(keyStore);
                return Arrays.stream(factory.getTrustManagers()).filter(tm -> tm instanceof X509ExtendedTrustManager).map(tm -> (X509ExtendedTrustManager)tm).findFirst();
            }
            catch (NoSuchAlgorithmException ex) {
                return Optional.empty();
            }
        }
    }
}

