/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.ssl;

import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Strings;
import java.security.KeyStore;
import java.util.Optional;
import java.util.Properties;

public final class SSLConfig {
    public static final String ENABLE_SSL = "ssl";
    public static final String TRUST_STORE_TYPE = "trustStoreType";
    public static final String TRUST_STORE_PATH = "trustStore";
    public static final String TRUST_STORE_PASSWORD = "trustStorePassword";
    public static final String DISABLE_CERT_VERIFICATION = "disableCertificateVerification";
    public static final String DISABLE_HOST_VERIFICATION = "disableHostVerification";
    public static final String USE_SYSTEM_TRUST_STORE = "useSystemTrustStore";
    @VisibleForTesting
    public static final String UNSPECIFIED = "";
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String trustStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean disablePeerVerification;
    private final boolean disableHostVerification;
    private final boolean useSystemTrustStore;

    private SSLConfig(Builder builder) {
        this.keyStoreType = builder.keyStoreType;
        this.keyStorePath = builder.keyStorePath;
        this.keyStorePassword = builder.keyStorePassword;
        this.keyPassword = builder.keyPassword == null ? builder.keyStorePassword : builder.keyPassword;
        this.trustStoreType = builder.trustStoreType;
        this.trustStorePath = builder.trustStorePath;
        this.trustStorePassword = builder.trustStorePassword;
        this.disablePeerVerification = builder.disablePeerVerification;
        this.disableHostVerification = builder.disableHostVerification;
        this.useSystemTrustStore = builder.useSystemTrustStore;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public boolean useDefaultTrustStore() {
        return Strings.isNullOrEmpty(this.trustStoreType) && Strings.isNullOrEmpty(this.trustStorePath);
    }

    public String getTrustStoreType() {
        if (!Strings.isNullOrEmpty(this.trustStoreType)) {
            return this.trustStoreType;
        }
        return KeyStore.getDefaultType();
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean disablePeerVerification() {
        return this.disablePeerVerification;
    }

    public boolean disableHostVerification() {
        return this.disableHostVerification;
    }

    public boolean useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public static Builder newBuilderForServer() {
        return new Builder().useSystemTrustStore(false);
    }

    public static Builder newBuilderForClient() {
        return new Builder().useSystemTrustStore(true);
    }

    public static Optional<SSLConfig> of(Properties properties) {
        if (properties == null) {
            return Optional.empty();
        }
        Properties canonicalProperties = new Properties();
        properties.stringPropertyNames().forEach(s2 -> canonicalProperties.setProperty(s2.toLowerCase(), properties.getProperty((String)s2)));
        Optional<Boolean> enabledOption = SSLConfig.getBooleanProperty(canonicalProperties, ENABLE_SSL);
        return enabledOption.filter(Boolean::booleanValue).map(ignored -> {
            Builder builder = SSLConfig.newBuilderForClient();
            SSLConfig.getStringProperty(canonicalProperties, TRUST_STORE_TYPE).ifPresent(builder::setTrustStoreType);
            SSLConfig.getStringProperty(canonicalProperties, TRUST_STORE_PATH).ifPresent(builder::setTrustStorePath);
            SSLConfig.getStringProperty(canonicalProperties, TRUST_STORE_PASSWORD).ifPresent(builder::setTrustStorePassword);
            SSLConfig.getBooleanProperty(canonicalProperties, DISABLE_CERT_VERIFICATION).ifPresent(builder::setDisablePeerVerification);
            SSLConfig.getBooleanProperty(canonicalProperties, DISABLE_HOST_VERIFICATION).ifPresent(builder::setDisableHostVerification);
            SSLConfig.getBooleanProperty(canonicalProperties, USE_SYSTEM_TRUST_STORE).ifPresent(builder::useSystemTrustStore);
            return builder.build();
        });
    }

    private static Optional<Boolean> getBooleanProperty(Properties canonicalProperties, String key) {
        return Optional.ofNullable(canonicalProperties.getProperty(key.toLowerCase())).map(Boolean::parseBoolean);
    }

    private static Optional<String> getStringProperty(Properties canonicalProperties, String key) {
        return Optional.ofNullable(canonicalProperties.getProperty(key.toLowerCase()));
    }

    public static final class Builder {
        private String keyStoreType = KeyStore.getDefaultType();
        private String keyStorePath = "";
        private String keyStorePassword = "";
        private String keyPassword = null;
        private String trustStoreType = "";
        private String trustStorePath = "";
        private String trustStorePassword = "";
        private boolean disablePeerVerification = false;
        private boolean disableHostVerification = false;
        private boolean useSystemTrustStore = false;

        private Builder() {
        }

        public Builder setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder setTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder setDisablePeerVerification(boolean disable) {
            this.disablePeerVerification = disable;
            return this;
        }

        public Builder setDisableHostVerification(boolean disable) {
            this.disableHostVerification = disable;
            return this;
        }

        public Builder useSystemTrustStore(boolean enable) {
            this.useSystemTrustStore = enable;
            return this;
        }

        public SSLConfig build() {
            return new SSLConfig(this);
        }
    }
}

