/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.config;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.NamedThreadFactory;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.config.RefreshConfiguration;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Provider;

public class AutoRefreshConfigurator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoRefreshConfigurator.class);
    private static final long DEFAULT_MINIMUM_REFRESH_FREQUENCY = TimeUnit.SECONDS.toMillis(90L);
    private final Provider<CompleteRefreshConfig<T>> getter;
    private final long minRefreshIntervalMS;
    private volatile boolean refreshEnabled = true;
    private volatile long refreshIntervalMS;
    private final ValueChangeDetector<T> trigger;
    private final ScheduledExecutorService refreshScheduler;

    public AutoRefreshConfigurator(Provider<CompleteRefreshConfig<T>> getter, Consumer<T> listener) {
        this(getter, listener, DEFAULT_MINIMUM_REFRESH_FREQUENCY);
    }

    public AutoRefreshConfigurator(Provider<CompleteRefreshConfig<T>> getter, Consumer<T> listener, long minRefreshIntervalMS) {
        this.getter = getter;
        this.refreshIntervalMS = this.minRefreshIntervalMS = minRefreshIntervalMS;
        this.trigger = new ValueChangeDetector<T>(listener);
        this.refreshScheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("config-refresh"));
        this.refreshScheduler.submit(() -> this.refresh(true));
    }

    private void refresh(boolean initialLoad) {
        CompleteRefreshConfig newState = (CompleteRefreshConfig)this.getter.get();
        if (newState != null) {
            RefreshConfiguration refreshConf = newState.getRefreshConfiguration();
            if (refreshConf != null) {
                this.refreshEnabled = refreshConf.isEnabled();
                long proposedRefreshMs = refreshConf.getIntervalMS();
                if (proposedRefreshMs < this.minRefreshIntervalMS) {
                    if (initialLoad) {
                        LOGGER.warn("Requested configuration refresh frequency {}ms. Adjusting to minimum of {}ms.", (Object)proposedRefreshMs, (Object)this.minRefreshIntervalMS);
                    } else {
                        LOGGER.debug("Requested configuration refresh frequency {}ms. Adjusting to minimum of {}ms.", (Object)proposedRefreshMs, (Object)this.minRefreshIntervalMS);
                    }
                    this.refreshIntervalMS = this.minRefreshIntervalMS;
                } else {
                    this.refreshIntervalMS = proposedRefreshMs;
                }
            } else if (initialLoad) {
                LOGGER.warn("Could not detect refresh settings. Continuing to refresh at {}s intervals.", (Object)TimeUnit.MILLISECONDS.toSeconds(this.refreshIntervalMS));
            } else {
                LOGGER.debug("Could not detect refresh settings. Continuing to refresh at {}s intervals.", (Object)TimeUnit.MILLISECONDS.toSeconds(this.refreshIntervalMS));
            }
            this.trigger.checkNewValue(newState.getUserConfig());
        }
        if (this.refreshEnabled) {
            this.refreshScheduler.schedule(() -> this.refresh(false), this.refreshIntervalMS, TimeUnit.MILLISECONDS);
        }
    }

    public static class ValueChangeDetector<T> {
        private boolean prevIsNull = true;
        private T lastValue;
        private final Consumer<T> reaction;

        public ValueChangeDetector(Consumer<T> reaction) {
            this.reaction = reaction;
        }

        public void checkNewValue(T newVal) {
            if (newVal == null) {
                if (!this.prevIsNull) {
                    this.reaction.accept(null);
                    this.prevIsNull = true;
                }
                return;
            }
            int h2 = newVal.hashCode();
            if (!newVal.equals(this.lastValue) || this.prevIsNull) {
                this.lastValue = newVal;
                this.prevIsNull = false;
                this.reaction.accept(newVal);
            }
        }

        public T getLastValue() {
            return this.lastValue;
        }
    }

    public static class CompleteRefreshConfig<T> {
        private final RefreshConfiguration refreshConfiguration;
        private final T userConfig;

        public CompleteRefreshConfig(RefreshConfiguration refreshConfiguration, T userConfig) {
            this.refreshConfiguration = refreshConfiguration;
            this.userConfig = userConfig;
        }

        public T getUserConfig() {
            return this.userConfig;
        }

        public RefreshConfiguration getRefreshConfiguration() {
            return this.refreshConfiguration;
        }
    }
}

