/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.config;

import com.dremio.jdbc.shaded.com.dremio.telemetry.api.config.MetricsConfigurator;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.config.RefreshConfiguration;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.config.TracerConfigurator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class TelemetryConfigurator
implements AutoCloseable {
    private final List<MetricsConfigurator> metricsConfigs;
    private final RefreshConfiguration refreshConfig;
    private final TracerConfigurator traceConfig;

    @JsonCreator
    public TelemetryConfigurator(@JsonProperty(value="auto-reload") RefreshConfiguration refreshConfig, @JsonProperty(value="metrics") List<MetricsConfigurator> metricsConfigs, @JsonProperty(value="tracing") TracerConfigurator traceConfig) {
        this.refreshConfig = refreshConfig;
        this.metricsConfigs = metricsConfigs;
        this.traceConfig = traceConfig;
    }

    @Override
    public void close() {
        this.metricsConfigs.forEach(MetricsConfigurator::close);
    }

    public List<MetricsConfigurator> getMetricsConfigs() {
        return this.metricsConfigs == null ? null : Collections.unmodifiableList(this.metricsConfigs);
    }

    public RefreshConfiguration getRefreshConfig() {
        return this.refreshConfig;
    }

    public TracerConfigurator getTracerConfig() {
        return this.traceConfig;
    }
}

