/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.Gauge;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.base.Strings;
import com.dremio.jdbc.shaded.com.google.common.util.concurrent.AtomicDouble;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Counter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.DistributionSummary;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Meter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tag;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tags;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class MeterProviders {
    private static final Map<Meter.Id, AtomicDouble> gauges = new ConcurrentHashMap<Meter.Id, AtomicDouble>();

    public static Meter.MeterProvider<Counter> newCounterProvider(String name, String description, Iterable<Tag> tags) {
        return Counter.builder(name).description(description).tags(tags).withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<Counter> newCounterProvider(String name, String description) {
        return Counter.builder(name).description(description).withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<Counter> newCounterProvider(String name, Iterable<Tag> tags) {
        return Counter.builder(name).tags(tags).withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<Counter> newCounterProvider(String name) {
        return Counter.builder(name).withRegistry(Metrics.globalRegistry);
    }

    public static Supplier<Timer.ResourceSample> newTimerResourceSampleSupplier(String name) {
        return () -> Timer.resource(Metrics.globalRegistry, name);
    }

    public static Supplier<Timer.ResourceSample> newTimerResourceSampleSupplier(String name, Iterable<Tag> tags) {
        return () -> (Timer.ResourceSample)Timer.resource(Metrics.globalRegistry, name).tags(tags);
    }

    public static Supplier<Timer.ResourceSample> newTimerResourceSampleSupplier(String name, String description) {
        return () -> (Timer.ResourceSample)Timer.resource(Metrics.globalRegistry, name).description(description);
    }

    public static Timer.ResourceSample newTimerResourceSample(String name) {
        return Timer.resource(Metrics.globalRegistry, name);
    }

    public static Timer.ResourceSample newTimerResourceSample(String name, String description) {
        return (Timer.ResourceSample)Timer.resource(Metrics.globalRegistry, name).description(description);
    }

    public static Timer.ResourceSample newTimerResourceSample(String name, String description, Iterable<Tag> tags) {
        return (Timer.ResourceSample)((Timer.ResourceSample)Timer.resource(Metrics.globalRegistry, name).description(description)).tags(tags);
    }

    public static Meter.MeterProvider<Timer> newTimerProvider(String name) {
        return Timer.builder(name).withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<Timer> newTimerProvider(String name, String description) {
        return Timer.builder(name).description(description).withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<DistributionSummary> newDistributionSummaryProvider(String name) {
        return DistributionSummary.builder(name).publishPercentileHistogram().withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<DistributionSummary> newDistributionSummaryProvider(String name, String description) {
        return DistributionSummary.builder(name).description(description).publishPercentileHistogram().withRegistry(Metrics.globalRegistry);
    }

    public static Meter.MeterProvider<DistributionSummary> newDistributionSummaryProvider(String name, String description, Iterable<Tag> tags) {
        return DistributionSummary.builder(name).description(description).tags(tags).publishPercentileHistogram().withRegistry(Metrics.globalRegistry);
    }

    public static com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge newGauge(String name, Supplier<Number> f) {
        return com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge.builder(name, f).register(Metrics.globalRegistry);
    }

    public static com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge newGauge(String name, String description, Supplier<Number> f) {
        return com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge.builder(name, f).description(description).register(Metrics.globalRegistry);
    }

    public static com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge newGauge(String name, String description, Iterable<Tag> tags, Supplier<Number> f) {
        return com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge.builder(name, f).description(description).tags(tags).register(Metrics.globalRegistry);
    }

    public static Gauge newGaugeProvider(final String name, final String description) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Gauge name can not be null or empty!");
        return new Gauge(){

            @Override
            public void set(double value, String ... labelValues) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(double value, Tags tags) {
                AtomicDouble gauge = gauges.computeIfAbsent(new Meter.Id(name, tags, null, description, Meter.Type.GAUGE), k -> new AtomicDouble());
                MeterProviders.newGauge(name, description, tags, gauge::get);
                gauge.set(value);
            }
        };
    }

    private MeterProviders() {
    }
}

