/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.codahale.metrics.Metric;
import com.dremio.jdbc.shaded.com.codahale.metrics.MetricRegistry;
import com.dremio.jdbc.shaded.com.codahale.metrics.MetricSet;
import com.dremio.jdbc.shaded.com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.dremio.jdbc.shaded.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.dremio.jdbc.shaded.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.dremio.jdbc.shaded.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.config.MetricsConfigurator;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.ReporterManager;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Joiner;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Clock;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Meter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tag;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tags;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.system.UptimeMetrics;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.config.NamingConvention;
import com.dremio.jdbc.shaded.io.micrometer.jmx.JmxConfig;
import com.dremio.jdbc.shaded.io.micrometer.jmx.JmxMeterRegistry;
import com.dremio.jdbc.shaded.io.micrometer.prometheus.HistogramFlavor;
import com.dremio.jdbc.shaded.io.micrometer.prometheus.PrometheusConfig;
import com.dremio.jdbc.shaded.io.micrometer.prometheus.PrometheusMeterRegistry;
import com.dremio.jdbc.shaded.io.prometheus.client.Collector;
import com.dremio.jdbc.shaded.io.prometheus.client.CollectorRegistry;
import com.dremio.jdbc.shaded.io.prometheus.client.dropwizard.DropwizardExports;
import com.dremio.jdbc.shaded.io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import com.dremio.jdbc.shaded.io.prometheus.client.exporter.MetricsServlet;
import com.dremio.jdbc.shaded.io.prometheus.client.hotspot.StandardExports;
import com.dremio.jdbc.shaded.org.jetbrains.annotations.NotNull;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;

public final class Metrics {
    public static final String DREMIO_MICROMETER_HISTOGRAM_FLAVOR_ENV_VAR = "DREMIO_MICROMETER_HISTOGRAM_FLAVOR";
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);

    public static Meter unregister(Meter meter) {
        Meter removed = com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry.remove(meter);
        if (removed != null) {
            logger.info("Removing old meter from globalRegistry. Meter ID: {}", (Object)meter.getId());
        }
        return removed;
    }

    public static Meter unregister(String meterName) {
        Meter meter = com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry.find(meterName).meter();
        if (meter != null) {
            return Metrics.unregister(meter);
        }
        logger.warn("Meter not found in globalRegistry. Meter name: {}", (Object)meterName);
        return null;
    }

    private static MetricSet scoped(final String name, final MetricSet metricSet) {
        return new MetricSet(){

            @Override
            public Map<String, Metric> getMetrics() {
                ImmutableMap.Builder<String, Metric> scopedMetrics = ImmutableMap.builder();
                for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
                    scopedMetrics.put(MetricRegistry.name(name, entry.getKey()), entry.getValue());
                }
                return scopedMetrics.build();
            }
        };
    }

    public static void onChange(Collection<MetricsConfigurator> updated) {
        RegistryHolder.reporters.onChange(updated);
    }

    public static void resetMetrics() {
        com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry.forEachMeter(com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry::remove);
        RegistryHolder.codahaleMetricRegistry.removeMatching((a, b) -> true);
        RegistryHolder.registerSysStats();
    }

    @VisibleForTesting
    public static Collection<MetricsConfigurator> getConfigurators() {
        return RegistryHolder.reporters.getParentConfigurators();
    }

    public static String join(String ... fields) {
        return Joiner.on('.').join(fields);
    }

    public static String scrape() {
        return RegistryHolder.getPrometheusMeterRegistry().scrape();
    }

    @VisibleForTesting
    public static class RegistryHolder {
        private static final String GC = "gc";
        private static final String BUFFER_POOL = "buffer-pool";
        private static final String MEMORY = "memory";
        private static final String THREADS = "threads";
        static final Tags LEGACY_TAGS = Tags.of(Tag.of("metric_type", "legacy"));
        private static MetricRegistry codahaleMetricRegistry;
        private static ReporterManager reporters;
        private static PrometheusMeterRegistry prometheusMeterRegistry;

        public static PrometheusMeterRegistry getPrometheusMeterRegistry() {
            return prometheusMeterRegistry;
        }

        @VisibleForTesting
        public static void initRegistry() {
            RegistryHolder.initRegistry(Optional.ofNullable(System.getenv(Metrics.DREMIO_MICROMETER_HISTOGRAM_FLAVOR_ENV_VAR)));
        }

        @VisibleForTesting
        public static void initRegistry(Optional<String> oHistogramFlavor) {
            prometheusMeterRegistry = com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry.getRegistries().stream().filter(registry -> registry instanceof PrometheusMeterRegistry).findFirst().map(registry -> (PrometheusMeterRegistry)registry).orElseGet(() -> {
                PrometheusMeterRegistry newPrometheusRegistry = RegistryHolder.newPrometheusMeterRegistry(oHistogramFlavor);
                newPrometheusRegistry.getPrometheusRegistry().register(new FilteredStandardExports());
                com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry.add(newPrometheusRegistry);
                JmxMeterRegistry jmxMeterRegistry = new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM);
                jmxMeterRegistry.config().namingConvention(NamingConvention.identity);
                com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry.add(jmxMeterRegistry);
                Stream.of(new ClassLoaderMetrics(), new JvmHeapPressureMetrics(), new JvmMemoryMetrics(), new JvmThreadMetrics(), new JvmGcMetrics(), new UptimeMetrics(), new ProcessorMetrics(), new FileDescriptorMetrics()).forEach(binder -> binder.bindTo(com.dremio.jdbc.shaded.io.micrometer.core.instrument.Metrics.globalRegistry));
                return newPrometheusRegistry;
            });
            codahaleMetricRegistry = new MetricRegistry();
            RegistryHolder.registerSysStats();
            CollectorRegistry collectorRegistry = prometheusMeterRegistry.getPrometheusRegistry();
            collectorRegistry.register(new DropwizardExports(codahaleMetricRegistry, RegistryHolder.newLegacyTagsSampleBuilder()));
            reporters = new ReporterManager(codahaleMetricRegistry);
        }

        @NotNull
        private static PrometheusMeterRegistry newPrometheusMeterRegistry(Optional<String> oHistogramFlavor) {
            final HistogramFlavor histogramFlavor = oHistogramFlavor.map(v -> {
                try {
                    return HistogramFlavor.valueOf(v);
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Invalid histogram flavor provided: {}. Defaulting to Prometheus.", v);
                    return HistogramFlavor.Prometheus;
                }
            }).orElse(HistogramFlavor.Prometheus);
            logger.info("Using histogram flavor: {}", (Object)histogramFlavor);
            return new PrometheusMeterRegistry(new PrometheusConfig(){

                @Override
                public String get(String key) {
                    return null;
                }

                @Override
                public HistogramFlavor histogramFlavor() {
                    return histogramFlavor;
                }
            });
        }

        @NotNull
        private static DefaultSampleBuilder newLegacyTagsSampleBuilder() {
            return new DefaultSampleBuilder(){

                @Override
                public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
                    if (Stream.of(RegistryHolder.GC, RegistryHolder.BUFFER_POOL, RegistryHolder.MEMORY, RegistryHolder.THREADS).noneMatch(dropwizardName::startsWith)) {
                        ArrayList<String> newAdditionalLabelNames = new ArrayList<String>(additionalLabelNames);
                        ArrayList<String> newAdditionalLabelValues = new ArrayList<String>(additionalLabelValues);
                        LEGACY_TAGS.forEach(tag -> {
                            newAdditionalLabelNames.add(tag.getKey());
                            newAdditionalLabelValues.add(tag.getValue());
                        });
                        return super.createSample(dropwizardName, nameSuffix, newAdditionalLabelNames, newAdditionalLabelValues, value);
                    }
                    return super.createSample(dropwizardName, nameSuffix, additionalLabelNames, additionalLabelValues, value);
                }
            };
        }

        private static void registerSysStats() {
            codahaleMetricRegistry.registerAll(Metrics.scoped(GC, new GarbageCollectorMetricSet()));
            codahaleMetricRegistry.registerAll(Metrics.scoped(BUFFER_POOL, new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer())));
            codahaleMetricRegistry.registerAll(Metrics.scoped(MEMORY, new MemoryUsageGaugeSet()));
            codahaleMetricRegistry.registerAll(Metrics.scoped(THREADS, new ThreadStatesGaugeSet()));
        }

        static {
            RegistryHolder.initRegistry();
        }
    }

    private static final class FilteredStandardExports
    extends StandardExports {
        private FilteredStandardExports() {
        }

        @Override
        public List<Collector.MetricFamilySamples> collect() {
            return super.collect().stream().filter(sample -> !sample.name.equals("process_start_time_seconds")).collect(Collectors.toList());
        }
    }

    public static class MetricServletFactory {
        public static Servlet createMetricsServlet() {
            return new MetricsServlet(RegistryHolder.prometheusMeterRegistry.getPrometheusRegistry());
        }
    }
}

