/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.DefaultMetricsProvider;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.MetricsProvider;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.SimpleCounter;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.TimerUtils;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Callable;
import javax.annotation.CheckReturnValue;

public final class MetricsInstrumenter {
    static final String ERROR_METRIC_SUFFIX = "error";
    static final String COUNT_METRIC_SUFFIX = "count";
    static final String TIME_METRIC_SUFFIX = "time";
    private final String serviceName;
    private final MetricsProvider provider;

    public <T> MetricsInstrumenter(Class<T> serviceClass) {
        this(serviceClass.getSimpleName().toLowerCase(), new DefaultMetricsProvider());
    }

    @VisibleForTesting
    MetricsInstrumenter(String serviceName, MetricsProvider provider) {
        this.serviceName = serviceName;
        this.provider = provider;
    }

    public void log(String operationName, Runnable runnable) {
        this.instrument(operationName, runnable).run();
    }

    public <T> T log(String operationName, Callable<T> callable) {
        try {
            return this.instrument(operationName, callable).call();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @CheckReturnValue
    public Runnable instrument(String operationName, Runnable runnable) {
        return () -> {
            SimpleCounter counter = this.provider.counter(String.join((CharSequence)".", this.serviceName, operationName, COUNT_METRIC_SUFFIX));
            SimpleCounter errorCounter = this.provider.counter(String.join((CharSequence)".", this.serviceName, operationName, ERROR_METRIC_SUFFIX));
            TimerUtils.timedOperation(this.provider.timer(String.join((CharSequence)".", this.serviceName, operationName, TIME_METRIC_SUFFIX)).start(), () -> {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    errorCounter.increment();
                    throw ex;
                }
                finally {
                    counter.increment();
                }
            });
        };
    }

    @CheckReturnValue
    public <T> Callable<T> instrument(String operationName, Callable<T> callable) {
        return () -> {
            SimpleCounter counter = this.provider.counter(String.join((CharSequence)".", this.serviceName, operationName, COUNT_METRIC_SUFFIX));
            SimpleCounter errorCounter = this.provider.counter(String.join((CharSequence)".", this.serviceName, operationName, ERROR_METRIC_SUFFIX));
            return TimerUtils.timedExceptionThrowingOperation(this.provider.timer(String.join((CharSequence)".", this.serviceName, operationName, TIME_METRIC_SUFFIX)).start(), () -> {
                try {
                    Object v = callable.call();
                    return v;
                }
                catch (Exception ex) {
                    errorCounter.increment();
                    throw ex;
                }
                finally {
                    counter.increment();
                }
            });
        };
    }
}

